<?php
/**
 * The Conference Pro Dynamic Styles
 * 
 * @package The_Conference_Pro
*/

function the_conference_pro_dynamic_css(){
    
    $primary_font         = get_theme_mod( 'primary_font', 'Nunito Sans' );
    $primary_fonts        = the_conference_pro_get_fonts( $primary_font, 'regular' );
    $font_size            = get_theme_mod( 'font_size', 18 );
    
    $site_title_font      = get_theme_mod( 'site_title_font', array( 'font-family'=>'Nunito Sans', 'variant'=>'regular' ) );
    $site_title_fonts     = the_conference_pro_get_fonts( $site_title_font['font-family'], $site_title_font['variant'] );
    $site_title_font_size = get_theme_mod( 'site_title_font_size', 26 );
    
    $h1_font              = get_theme_mod( 'h1_font', array( 'font-family'=>'Nunito Sans', 'variant'=>'regular') );
    $h1_fonts             = the_conference_pro_get_fonts( $h1_font['font-family'], $h1_font['variant'] );
    $h1_font_size         = get_theme_mod( 'h1_font_size', 49 );
    
    $h2_font              = get_theme_mod( 'h2_font', array('font-family'=>'Nunito Sans', 'variant'=>'regular') );
    $h2_fonts             = the_conference_pro_get_fonts( $h2_font['font-family'], $h2_font['variant'] );
    $h2_font_size         = get_theme_mod( 'h2_font_size', 39 );
    
    $h3_font              = get_theme_mod( 'h3_font', array('font-family'=>'Nunito Sans', 'variant'=>'regular') );
    $h3_fonts             = the_conference_pro_get_fonts( $h3_font['font-family'], $h3_font['variant'] );
    $h3_font_size         = get_theme_mod( 'h3_font_size', 31 );
    
    $h4_font              = get_theme_mod( 'h4_font', array('font-family'=>'Nunito Sans', 'variant'=>'regular') );
    $h4_fonts             = the_conference_pro_get_fonts( $h4_font['font-family'], $h4_font['variant'] );
    $h4_font_size         = get_theme_mod( 'h4_font_size', 25 );
    
    $h5_font              = get_theme_mod( 'h5_font', array('font-family'=>'Nunito Sans', 'variant'=>'regular') );
    $h5_fonts             = the_conference_pro_get_fonts( $h5_font['font-family'], $h5_font['variant'] );
    $h5_font_size         = get_theme_mod( 'h5_font_size', 20 );
    
    $h6_font              = get_theme_mod( 'h6_font', array('font-family'=>'Nunito Sans', 'variant'=>'regular') );
    $h6_fonts             = the_conference_pro_get_fonts( $h6_font['font-family'], $h6_font['variant'] );
    $h6_font_size         = get_theme_mod( 'h6_font_size', 16 );
    
    $primary_color        = get_theme_mod( 'primary_color', '#57b9a8' );
    $site_title_color     = get_theme_mod( 'site_title_color', '#ffffff' );
    $secondary_color      = get_theme_mod( 'secondary_color', '#0d2d62' ); // Secondary Color
    $footer_bg_color      = get_theme_mod( 'footer_bg_color', '#212127' ); // Secondary Color
    $body_bg              = get_theme_mod( 'body_bg', 'image' );
    $bg_pattern           = get_theme_mod( 'bg_pattern', 'nobg' );
    
    $primary_rgb          = the_conference_pro_hex2rgb( the_conference_pro_sanitize_hex_color( $primary_color ) );
    $secondary_rgb        = the_conference_pro_hex2rgb( the_conference_pro_sanitize_hex_color( $secondary_color ) );

    $header_layouts       = get_theme_mod( 'header_layout', 'one' ); // Header layouts

    if( in_array( $header_layouts, array( 'four', 'five' ) ) && '#ffffff' == $site_title_color ){
        $site_title_color = '#111111';
    }

    $image = '';
    
     
    echo "<style type='text/css' media='all'>"; 

    if( $body_bg == 'pattern' && $bg_pattern != 'nobg' ){
        $image = get_template_directory_uri() . '/images/patterns/' . $bg_pattern . '.png';
        echo 'body{ background: url(' . esc_url( $image ) . '); }';
    }
    ?>
     
    .content-newsletter .blossomthemes-email-newsletter-wrapper.bg-img:after,
    .widget_blossomthemes_email_newsletter_widget .blossomthemes-email-newsletter-wrapper:after{
        <?php echo 'background: rgba(' . $primary_rgb[0] . ', ' . $primary_rgb[1] . ', ' . $primary_rgb[2] . ', 0.8);'; ?>
    }

    <?php 
    if( $body_bg == 'pattern' ){ ?>
        body.custom-background {
            background: url(<?php echo esc_url( $image ); ?>);
        }
        <?php 
    } 
    ?>
    
    /*Typography*/

    body,
    button,
    input,
    select,
    optgroup,
    textarea{
        font-family : <?php echo esc_html( $primary_fonts['font'] ); ?>;
        font-size   : <?php echo absint( $font_size ); ?>px;        
    }
    
    .site-title{
        font-size   : <?php echo absint( $site_title_font_size ); ?>px;
        font-family : <?php echo esc_html( $site_title_fonts['font'] ); ?>;
        font-weight : <?php echo esc_html( $site_title_fonts['weight'] ); ?>;
        font-style  : <?php echo esc_html( $site_title_fonts['style'] ); ?>;
    }
    
    .site-title a{
		color: <?php echo the_conference_pro_sanitize_hex_color( $site_title_color ); ?>;
	}

    /*Typography*/
    #primary .post .entry-content h1,
    #primary .page .entry-content h1{
        font-family: <?php echo esc_html( $h1_fonts['font'] ); ?>;
        font-size: <?php echo absint( $h1_font_size ); ?>px;        
    }
    
    #primary .post .entry-content h2,
    #primary .page .entry-content h2{
        font-family: <?php echo esc_html( $h2_fonts['font'] ); ?>;
        font-size: <?php echo absint( $h2_font_size ); ?>px;
    }
    
    #primary .post .entry-content h3,
    #primary .page .entry-content h3{
        font-family: <?php echo esc_html( $h3_fonts['font'] ); ?>;
        font-size: <?php echo absint( $h3_font_size ); ?>px;
    }
    
    #primary .post .entry-content h4,
    #primary .page .entry-content h4{
        font-family: <?php echo esc_html( $h4_fonts['font'] ); ?>;
        font-size: <?php echo absint( $h4_font_size ); ?>px;
    }
    
    #primary .post .entry-content h5,
    #primary .page .entry-content h5{
        font-family: <?php echo esc_html( $h5_fonts['font'] ); ?>;
        font-size: <?php echo absint( $h5_font_size ); ?>px;
    }
    
    #primary .post .entry-content h6,
    #primary .page .entry-content h6{
        font-family: <?php echo esc_html( $h6_fonts['font'] ); ?>;
        font-size: <?php echo absint( $h6_font_size ); ?>px;
    }
    
    /* Primary Color Scheme*/
    a:hover, button:hover,
    input[type="button"]:hover,
    input[type="reset"]:hover,
    input[type="submit"]:hover, .edit-link a:hover, .scroll-to-top, 
    .comment-body .reply .comment-reply-link:hover, .comment-respond .comment-reply-title a:hover, 
    .breadcrumb .current a, #load-posts a:hover, .main-navigation ul li a:hover, 
    .main-navigation ul li:hover > a, 
    .main-navigation ul li.current-menu-item > a, 
    .main-navigation ul li.current_page_item > a, .nav-wrap .nav-btn a:hover, a.btn-transparent, 
    .btn-readmore, .tab-description .tab-wrap li:hover, .tab-description .tab-wrap li.active, .toggle-block .toggle-title .speaker-name a, .btn-wrap a.btn-filled:hover, .pricingtable-block .pricingtable-price sup, .pricingtable-block .pricingtable-price .price, .pricingtable-block .pricingtable-btn a, .pricingtable-block.has-tag .pricingtable-btn a:hover, 
    .testimonial-section .btn-wrap a.btn-filled:hover, .ctatimer-section a.btn-filled, .btn-cta, 
    .gallery-img-wrap .gallery-img .gallery:hover, .flashy-overlay .flashy-numeration, .gallery-section a.btn-filled:hover, 
    span.category a:hover, .blossomthemes-email-newsletter-wrapper form label:hover, .blossomthemes-email-newsletter-wrapper form input[type="submit"]:hover, .blossomthemes-email-newsletter-wrapper form #loader-156, .top-footer .widget ul li a:hover, .blog .site-main article a.btn-transparent:hover, .widget_twitter_feeds ul li a, 
    .widget_twitter_feeds ul li a.twitter_time:hover, .contact-map-block ul li a, .widget_calendar table tbody tr td a, 
    .widget_raratheme_companion_faqs_widget ul.accordion li .toggle:hover, 
    .widget_raratheme_companion_faqs_widget ul.accordion li.show .toggle, .widget_rrtc_icon_text_widget a.btn-readmore:hover, 
    .widget_rrtc_icon_text_widget .widget_rrtc_icon_text_widget svg, .widget ul li .entry-meta a:hover, 
    .page-template-about .content-area .widget_raratheme_featured_page_widget a.btn-readmore:hover, 
    .page-template-sponsor .widget_raratheme_companion_cta_widget .button-wrap .btn-cta:hover, 
    .page-template-venue .site-main .venue-detail a.btn-readmore:hover, .page-template-venue .widget_raratheme_companion_cta_widget .button-wrap .btn-cta:hover, .archive .site-main article a.btn-transparent:hover, 
    .search .site-main article a.btn-transparent:hover, .error404 .not-found .error-num, .error404 .not-found .bttn:hover, 
    .page-template-about section.about-section .widget_rrtc_icon_text_widget .rtc-itw-inner-holder .icon-holder, 
    .widget_raratheme_featured_page_widget a.btn-readmore:hover, 
    .entry-header .portfolio-cat a:hover, 
    .widget_rtc_social_links ul li a:hover,
    #secondary .widget_raratheme_featured_widget .text-holder .readmore:hover, 
    .site-footer .widget_raratheme_featured_widget .text-holder .readmore:hover,
    #secondary .widget_raratheme_image_widget .readmore:hover, .site-footer .widget_raratheme_image_widget .readmore:hover,
    .main-navigation ul li a:hover, .main-navigation ul li:hover>a, .main-navigation ul li.current-menu-item>a, .main-navigation ul li.current_page_item>a{
		color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
	}


    @media screen and (min-width:1025px) {
        .main-navigation ul li.current-menu-item> .submenu-toggle svg path, .main-navigation ul li.current_page_item> .submenu-toggle svg path {
            fill: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
        }
    }
 

    @media screen and (max-width: 992px) {
        .main-navigation ul ul.sub-menu li a:hover, 
        .main-navigation ul ul.sub-menu li:hover > a, 
        .main-navigation ul ul.sub-menu li.current-menu-item a, 
        .main-navigation ul ul.sub-menu li.current_page_item a,
         {
            color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
        }
    }

    button,
    input[type="button"],
    input[type="reset"],
    input[type="submit"], .title-wrap::after, 
    .title-wrap::after, .cat-tags a:hover, .edit-link a, .owl-theme .owl-dots .owl-dot.active span, 
    .owl-theme .owl-dots .owl-dot:hover span, .scroll-to-top:hover, .navigation .nav-links .page-numbers:not(.dots):hover, 
    .navigation .nav-links .page-numbers.current, .posts-navigation .nav-links a:hover, #load-posts a, #load-posts a.disabled, 
    .main-navigation ul li ul li, .nav-wrap .nav-btn a, a.btn-transparent:hover, .btn-readmore:hover, a.btn-filled, 
    .tab-wrap li:hover, .tab-wrap li.active, .pricingtable-block.has-tag .pricingtable-tag .tag-inner, 
    .pricingtable-block.has-tag .pricingtable-btn a, .pricingtable-block .pricingtable-btn a:hover, span.category a, 
    .social-icons li a, .widget_social_links ul li a:hover, .single-post .article-share .social-icons li a:hover, 
    .author-social a:hover .icon, .widget_calendar table caption, .widget_tag_cloud a:hover, .widget_rrtc_icon_text_widget a.btn-readmore, .page-template-about .content-area .widget_raratheme_featured_page_widget a.btn-readmore, 
    .page-template-sponsor .widget_raratheme_companion_cta_widget .button-wrap .btn-cta, 
    .page-template-venue .site-main .venue-detail a.btn-readmore, 
    .page-template-venue .widget_raratheme_companion_cta_widget .button-wrap .btn-cta, .error404 .not-found .bttn, 
    .site-header.header-lay4 button.toggle-btn:hover, .site-header.header-lay5 button.toggle-btn:hover, .site-header.header-lay4 button.toggle-btn .bar, .site-header.header-lay5 button.toggle-btn .bar, 
    .site-header button.toggle-btn:hover .bar, .main-navigation button.toggle-button:hover, 
    section[class*="-section"] .widget_rrtc_icon_text_widget .icon-holder, 
    .widget_raratheme_featured_page_widget a.btn-readmore, 
    .portfolio-sorting .button.is-checked, .portfolio-sorting .button:hover, 
    .related-portfolio-title::after,
    .site-footer .widget_raratheme_author_bio .readmore, #secondary .widget_raratheme_author_bio .readmore,
    .site-footer .widget_raratheme_author_bio .social-share-list a, 
    #secondary .widget_raratheme_author_bio .social-share-list a,
     .site-footer .widget.widget_raratheme_custom_categories .raratheme-custom-categories-wrap .raratheme-custom-categories-meta-wrap .category-fallback-svg a, 
     #secondary .widget.widget_raratheme_custom_categories .raratheme-custom-categories-wrap .raratheme-custom-categories-meta-wrap .category-fallback-svg a,
     .site-footer .widget_raratheme_featured_widget .text-holder .readmore,
      #secondary .widget_raratheme_featured_widget .text-holder .readmore,
      #secondary .widget_raratheme_image_text_widget ul li .btn-readmore, 
      .site-footer .widget_raratheme_image_text_widget ul li .btn-readmore,
      #secondary .widget_raratheme_image_widget .readmore, 
      .site-footer .widget_raratheme_image_widget .readmore {
        background: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
    }

    .comment-respond .comment-form p.comment-form-cookies-consent input[type="checkbox"]:checked + label::before, 
    .flashy-overlay .flashy-close, .blossomthemes-email-newsletter-wrapper form label input[type="checkbox"]:checked + .check-mark, .search-form input.search-submit {
        background-color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
    }

    button,
    input[type="button"],
    input[type="reset"],
    input[type="submit"], .cat-tags a:hover, .edit-link a, .scroll-to-top, 
    .comment-respond .comment-form p.comment-form-cookies-consent input[type="checkbox"]:checked + label::before, 
    .navigation .nav-links .page-numbers:not(.dots):hover, 
    .navigation .nav-links .page-numbers.current, .posts-navigation .nav-links a:hover, #load-posts a, 
    .nav-wrap .nav-btn a, a.btn-transparent, 
    .btn-readmore, .site-banner a.btn-transparent:hover, a.btn-filled, .btn-wrap a.btn-filled:hover, 
    .pricingtable-block .pricingtable-btn a, .testimonial-section .btn-wrap a.btn-filled:hover, .gallery-section a.btn-filled:hover, .blossomthemes-email-newsletter-wrapper form label input[type="checkbox"]:checked + .check-mark, 
    .widget_social_links ul li a:hover, .single-post .article-share .social-icons li a:hover, 
    .author-social a:hover .icon, .widget_tag_cloud a:hover, .widget_rrtc_icon_text_widget a.btn-readmore, 
    .page-template-sponsor .widget_raratheme_companion_cta_widget .button-wrap .btn-cta, .page-template-venue .widget_raratheme_companion_cta_widget .button-wrap .btn-cta, .page-header .author-social a:hover .icon, 
    .error404 .not-found .bttn, .site-header.header-lay4 button.toggle-btn, 
    .site-header.header-lay5 button.toggle-btn, .widget_rtc_social_links ul li a:hover,
    .site-footer .widget_raratheme_featured_widget .text-holder .readmore, 
    #secondary .widget_raratheme_featured_widget .text-holder .readmore,
    #secondary .widget_raratheme_image_widget .readmore, 
    .site-footer .widget_raratheme_image_widget .readmore,
    #secondary .widget_raratheme_image_widget .readmore:hover, 
    .site-footer .widget_raratheme_image_widget .readmore:hover{
        border-color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
    }

    q, .main-navigation ul.nav-menu > li:nth-last-of-type(1) ul ul:before, 
    .main-navigation ul.nav-menu > li:nth-last-of-type(2) ul ul:before {
        border-left-color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
    }

    .main-navigation ul li ul:before {
        border-bottom-color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
    }

    .main-navigation ul li ul li ul:before {
        border-right-color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
    }

    .tab-wrap li:before {
        border-top-color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
    }

    svg .ph, svg .env, svg .mapb {
        fill: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
    }

    .site-header.sticky-menu.menu-stick, 
    body.home:not(.hasbanner) header.site-header {
        background: <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.85)'; ?>;
    }

    header.page-header:after, .banner-caption, .portfolio-item .portfolio-text-holder {
        background: -webkit-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.8)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.8)'; ?>);
        background: -moz-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.8)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.8)'; ?>);
        background: -ms-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.8)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.8)'; ?>);
        background: -o-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.8)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.8)'; ?>);
        background: linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.8)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.8)'; ?>);
    }

    .video-banner .banner-caption {
        background: -webkit-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.5)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.5)'; ?>);
        background: -moz-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.5)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.5)'; ?>);
        background: -ms-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.5)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.5)'; ?>);
        background: -o-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.5)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.5)'; ?>);
        background: linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.5)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.5)'; ?>);
    }

    section.counter-section:before, section.pricingtable-section:before, .ctatimer-section:before {
        background: -webkit-linear-gradient( <?php echo '135deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
        background: -moz-linear-gradient( <?php echo '135deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
        background: -ms-linear-gradient( <?php echo '135deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
        background: -o-linear-gradient( <?php echo '135deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
        background: linear-gradient( <?php echo '135deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
    }

    .widget_rrtc_description_widget .rtc-team-holder-modal {
        background: -webkit-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
        background: -moz-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
        background: -ms-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
        background: -o-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
        background: linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)'; ?>);
    }

    .widget_raratheme_companion_cta_widget .bttk-cta-bg::before, .gallery-img-wrap .gallery-img .text-holder {
        background: -webkit-linear-gradient( <?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)  85%'; ?>);
        background: -moz-linear-gradient( <?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)  85%'; ?>);
        background: -ms-linear-gradient( <?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)  85%'; ?>);
        background: -o-linear-gradient( <?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)  85%'; ?>);
        background: linear-gradient( <?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 0.9)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 0.9)  85%'; ?>);
    }

    .widget_raratheme_featured_page_widget .img-holder::before {
        background: -webkit-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)'; ?>);
        background: -moz-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)'; ?>);
        background: -ms-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)'; ?>);
        background: -o-linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)'; ?>);
        background: linear-gradient( <?php echo 'rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)'; ?>);
    }

    section.newsletter-section.gradient-enabled .blossomthemes-email-newsletter-wrapper {
        background: -webkit-linear-gradient(<?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)  85%'; ?>) !important;
        background: -moz-linear-gradient(<?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)  85%'; ?>) !important;
        background: -ms-linear-gradient(<?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)  85%'; ?>) !important;
        background: -o-linear-gradient(<?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)  85%'; ?>) !important;
        background: linear-gradient(<?php echo '90deg, rgba('. $primary_rgb[0].', '. $primary_rgb[1].', '.$primary_rgb[2].', 1)'; ?>, <?php echo 'rgba('. $secondary_rgb[0].', '. $secondary_rgb[1].', '.$secondary_rgb[2].', 1)  85%'; ?>) !important;
    }

    .comment-body .reply .comment-reply-link:hover:before {
        background-image: url('data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="<?php echo the_conference_pro_hash_to_percent23( the_conference_pro_sanitize_hex_color( $primary_color ) ); ?>" d="M8.309 189.836L184.313 37.851C199.719 24.546 224 35.347 224 56.015v80.053c160.629 1.839 288 34.032 288 186.258 0 61.441-39.581 122.309-83.333 154.132-13.653 9.931-33.111-2.533-28.077-18.631 45.344-145.012-21.507-183.51-176.59-185.742V360c0 20.7-24.3 31.453-39.687 18.164l-176.004-152c-11.071-9.562-11.086-26.753 0-36.328z"></path></svg>');
    }

    .toggle-block.open .toggle-title::before {
        background-image: url('data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="<?php echo the_conference_pro_hash_to_percent23( the_conference_pro_sanitize_hex_color( $primary_color ) ); ?>" d="M441.9 167.3l-19.8-19.8c-4.7-4.7-12.3-4.7-17 0L224 328.2 42.9 147.5c-4.7-4.7-12.3-4.7-17 0L6.1 167.3c-4.7 4.7-4.7 12.3 0 17l209.4 209.4c4.7 4.7 12.3 4.7 17 0l209.4-209.4c4.7-4.7 4.7-12.3 0-17z"></path></svg>');
    }

    .widget_raratheme_companion_faqs_widget ul.accordion li .toggle:hover::after, 
    .widget_raratheme_companion_faqs_widget ul.accordion li.show .toggle::after {
        background-image: url('data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path fill="<?php echo the_conference_pro_hash_to_percent23( the_conference_pro_sanitize_hex_color( $primary_color ) ); ?>" d="M151.5 347.8L3.5 201c-4.7-4.7-4.7-12.3 0-17l19.8-19.8c4.7-4.7 12.3-4.7 17 0L160 282.7l119.7-118.5c4.7-4.7 12.3-4.7 17 0l19.8 19.8c4.7 4.7 4.7 12.3 0 17l-148 146.8c-4.7 4.7-12.3 4.7-17 0z"></path></svg>');
    }

    blockquote {
        background-image: url('data:image/svg+xml; utf-8, <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 130 110"><path fill="<?php echo 'rgba(' . $primary_rgb[0] . ', ' . $primary_rgb[1] . ', ' . $primary_rgb[2] . ', 0.5)'; ?>" d="M88.967,47.167a26.667,26.667,0,1,1-26.8,26.667A53.319,53.319,0,0,1,115.5,20.5,52.413,52.413,0,0,0,88.967,47.167ZM58.833,73.833a26.667,26.667,0,0,1-53.333,0h0A53.319,53.319,0,0,1,58.833,20.5,52.413,52.413,0,0,0,32.3,47.167,26.631,26.631,0,0,1,58.833,73.833Z"></path></svg>');
    }
    
    <?php if( is_woocommerce_activated() ) { ?>
        .woocommerce ul.products li.product .price ins,
        .woocommerce div.product p.price ins,
        .woocommerce div.product span.price ins, 
        .woocommerce nav.woocommerce-pagination ul li a:hover,
        .woocommerce nav.woocommerce-pagination ul li a:focus, 
        .woocommerce div.product .entry-summary .woocommerce-product-rating .woocommerce-review-link:hover,
        .woocommerce div.product .entry-summary .woocommerce-product-rating .woocommerce-review-link:focus, 
        .woocommerce div.product .entry-summary .product_meta .posted_in a:hover,
         .woocommerce div.product .entry-summary .product_meta .posted_in a:focus,
         .woocommerce div.product .entry-summary .product_meta .tagged_as a:hover,
         .woocommerce div.product .entry-summary .product_meta .tagged_as a:focus, 
         .woocommerce-cart #primary .page .entry-content table.shop_table td.product-name a:hover,
        .woocommerce-cart #primary .page .entry-content table.shop_table td.product-name a:focus, 
        .widget.woocommerce ul li a:hover, .woocommerce #secondary .widget_price_filter .price_slider_amount .button:hover,
        .woocommerce #secondary .widget_price_filter .price_slider_amount .button:focus, 
        .widget.woocommerce ul li.cat-parent .cat-toggle:hover, 
        .woocommerce.widget .product_list_widget li .product-title:hover,
        .woocommerce.widget .product_list_widget li .product-title:focus, 
        .woocommerce.widget .product_list_widget li ins,
        .woocommerce.widget .product_list_widget li ins .amount, 
        .woocommerce ul.products li.product .price ins, .woocommerce div.product p.price ins, .woocommerce div.product span.price ins,
        .woocommerce div.product .entry-summary .product_meta .posted_in a:hover, .woocommerce div.product .entry-summary .product_meta .posted_in a:focus, .woocommerce div.product .entry-summary .product_meta .tagged_as a:hover, .woocommerce div.product .entry-summary .product_meta .tagged_as a:focus, 
        .woocommerce div.product .entry-summary .woocommerce-product-rating .woocommerce-review-link:hover, .woocommerce div.product .entry-summary .woocommerce-product-rating .woocommerce-review-link:focus, 
        .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li a:focus {
            color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
        }

        .woocommerce ul.products li.product .added_to_cart:hover,
        .woocommerce ul.products li.product .added_to_cart:focus, 
        .woocommerce ul.products li.product .add_to_cart_button:hover,
         .woocommerce ul.products li.product .add_to_cart_button:focus,
         .woocommerce ul.products li.product .product_type_external:hover,
         .woocommerce ul.products li.product .product_type_external:focus,
         .woocommerce ul.products li.product .ajax_add_to_cart:hover,
         .woocommerce ul.products li.product .ajax_add_to_cart:focus, 
         .woocommerce ul.products li.product .button.loading,
        .woocommerce-page ul.products li.product .button.loading, 
        .woocommerce nav.woocommerce-pagination ul li span.current, 
        .woocommerce div.product .entry-summary .variations_form .single_variation_wrap .button:hover,
        .woocommerce div.product .entry-summary .variations_form .single_variation_wrap .button:focus, 
        .woocommerce div.product form.cart .single_add_to_cart_button:hover,
         .woocommerce div.product form.cart .single_add_to_cart_button:focus,
         .woocommerce div.product .cart .single_add_to_cart_button.alt:hover,
         .woocommerce div.product .cart .single_add_to_cart_button.alt:focus, 
         .woocommerce-cart #primary .page .entry-content table.shop_table td.actions .coupon input[type="submit"]:hover,
        .woocommerce-cart #primary .page .entry-content table.shop_table td.actions .coupon input[type="submit"]:focus, 
        .woocommerce-cart #primary .page .entry-content .cart_totals .checkout-button:hover,
        .woocommerce-cart #primary .page .entry-content .cart_totals .checkout-button:focus, 
        .woocommerce-checkout .woocommerce .woocommerce-info, 
         .woocommerce-checkout .woocommerce form.woocommerce-form-login input.button:hover,
         .woocommerce-checkout .woocommerce form.woocommerce-form-login input.button:focus,
         .woocommerce-checkout .woocommerce form.checkout_coupon input.button:hover,
         .woocommerce-checkout .woocommerce form.checkout_coupon input.button:focus,
         .woocommerce form.lost_reset_password input.button:hover,
         .woocommerce form.lost_reset_password input.button:focus,
         .woocommerce .return-to-shop .button:hover,
         .woocommerce .return-to-shop .button:focus,
         .woocommerce #payment #place_order:hover,
         .woocommerce-page #payment #place_order:focus, 
         .woocommerce #respond input#submit:hover, 
         .woocommerce #respond input#submit:focus, 
         .woocommerce a.button:hover, 
         .woocommerce a.button:focus, 
         .woocommerce button.button:hover, 
         .woocommerce button.button:focus, 
         .woocommerce input.button:hover, 
         .woocommerce input.button:focus, 
         .woocommerce #secondary .widget_shopping_cart .buttons .button:hover,
        .woocommerce #secondary .widget_shopping_cart .buttons .button:focus, 
        .woocommerce #secondary .widget_price_filter .ui-slider .ui-slider-range, 
        .woocommerce #secondary .widget_price_filter .price_slider_amount .button,  
        .woocommerce .woocommerce-message .button:hover,
        .woocommerce .woocommerce-message .button:focus, 
        .woocommerce-account .woocommerce-MyAccount-navigation ul li.is-active a, .woocommerce-account .woocommerce-MyAccount-navigation ul li a:hover {
            background: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
        }

        .woocommerce .woocommerce-widget-layered-nav-list .woocommerce-widget-layered-nav-list__item.chosen a::before, 
        .widget.widget_layered_nav_filters ul li.chosen a:before, 
        .woocommerce-product-search button[type="submit"]:hover {
            background-color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
        }

        .woocommerce nav.woocommerce-pagination ul li a:hover,
        .woocommerce nav.woocommerce-pagination ul li a:focus, 
        .woocommerce nav.woocommerce-pagination ul li span.current, 
        .woocommerce .woocommerce-widget-layered-nav-list .woocommerce-widget-layered-nav-list__item a:hover:before, 
        .widget.widget_layered_nav_filters ul li a:hover:before, 
        .woocommerce .woocommerce-widget-layered-nav-list .woocommerce-widget-layered-nav-list__item.chosen a::before, 
        .widget.widget_layered_nav_filters ul li.chosen a:before, 
        .woocommerce #secondary .widget_price_filter .ui-slider .ui-slider-handle, 
        .woocommerce #secondary .widget_price_filter .price_slider_amount .button {
            border-color: <?php echo the_conference_pro_sanitize_hex_color( $primary_color ); ?>;
        }

    <?php } ?>
    
    /** Footer background color */
    .site-footer .top-footer {
        background: <?php echo the_conference_pro_sanitize_hex_color( $footer_bg_color ); ?>;
        padding: 80px 0 20px 0;
    }
           
    <?php echo "</style>";
}
add_action( 'wp_head', 'the_conference_pro_dynamic_css', 99 );

/**
 * Function for sanitizing Hex color 
 */
function the_conference_pro_sanitize_hex_color( $color ){
	if ( '' === $color )
		return '';

    // 3 or 6 hex digits, or the empty string.
	if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) )
		return $color;
}

/**
 * convert hex to rgb
 * @link http://bavotasan.com/2011/convert-hex-color-to-rgb-using-php/
*/
function the_conference_pro_hex2rgb($hex) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   //return implode(",", $rgb); // returns the rgb values separated by commas
   return $rgb; // returns an array with the rgb values
}

/**
 * Convert '#' to '%23'
*/
function the_conference_pro_hash_to_percent23( $color_code ){
    $color_code = str_replace( "#", "%23", $color_code );
    return $color_code;
}