<?php
/**
 * The Conference Pro functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package The_Conference_Pro
 */

$theme_data = wp_get_theme();
if( ! defined( 'THE_CONFERENCE_PRO_THEME_VERSION' ) ) define ( 'THE_CONFERENCE_PRO_THEME_VERSION', $theme_data->get( 'Version' ) );
if( ! defined( 'THE_CONFERENCE_PRO_THEME_NAME' ) ) define( 'THE_CONFERENCE_PRO_THEME_NAME', $theme_data->get( 'Name' ) );

/**
 * Custom Functions.
 */
require get_template_directory() . '/inc/custom-functions.php';

/**
 * Standalone Functions.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Template Functions.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Custom functions for selective refresh.
 */
require get_template_directory() . '/inc/partials.php';

/**
 * Custom Controls
 */
require get_template_directory() . '/inc/custom-controls/custom-control.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Widgets
 */
require get_template_directory() . '/inc/widgets/widgets.php';

/**
 * Metabox
 */
require get_template_directory() . '/inc/metabox/metabox.php';

/**
 * User Metabox
 */
require get_template_directory() . '/inc/metabox/user-metabox.php';

/**
 * Social Sharing
 */
require get_template_directory() . '/inc/social-sharing.php';

/**
 * Typography Functions
 */
require get_template_directory() . '/inc/typography/typography.php';

/**
 * Dynamic Styles
 */
require get_template_directory() . '/css/style.php';

/**
 * Performance
*/
require get_template_directory() . '/inc/performance.php';

/**
 * Plugin Recommendation
*/
require get_template_directory() . '/inc/tgmpa/recommended-plugins.php';

/**
 * Getting Started
*/
require get_template_directory() . '/inc/getting-started/getting-started.php';

/**
 * Theme Updater
*/
require get_template_directory() . '/updater/theme-updater.php';

/**
 * Demo Import
 */
require get_template_directory() . '/inc/import-hooks.php';

/**
 * Add theme compatibility function for woocommerce if active
*/
if( is_woocommerce_activated() ){
    require get_template_directory() . '/inc/woocommerce-functions.php';    
}

if( is_rara_theme_companion_activated() ){
	/**
	 * CPT
	 */
	require get_template_directory() . '/inc/cpt/cpt.php';
	
	/**
	 * Metabox for CPT
	 */
	require get_template_directory() .'/inc/cpt/metabox.php';

	/**
	 * Filters for RaraTheme Companion Plugin
	 */
	require get_template_directory() . '/inc/rrtc-filters.php';
}

if( is_btnw_activated() ){
	/**
	 * Filters for BlossomThemes Email Newsletter Plugin
	 */
	require get_template_directory() . '/inc/btnw-filters.php';
}
