<?php
/**
 * Rara Theme custom post and taxonomy definitions.
 *
 * @package The_Conference_Pro
 */

if( ! function_exists( 'the_conference_pro_custom_post_type' ) ) :
    /**
     * Filter the CPT generated by RTC
    */    
    function the_conference_pro_custom_post_type(){
        $posts = array(
            'rara-schedule' => array( 
    			'singular_name'	      => __( 'Schedule', 'the-conference-pro' ),
    			'general_name'	      => __( 'Schedules', 'the-conference-pro' ),
    			'dashicon'		      => 'dashicons-calendar-alt',
    			'taxonomy'		      => 'rara_schedule_categories',
    			'taxonomy_slug'	      => 'schedules',
                'has_archive'         => false,		
    			'exclude_from_search' => false,
    			'show_in_nav_menus'	  => false,
                'show_in_rest'        => true,
    			'supports' 			  => array( 'title', 'editor', 'thumbnail', 'excerpt' ,'page-attributes' ),
    			'rewrite'             => array( 'slug' => 'schedule' ),
    			'hierarchical'		  => false,
    		),
    		'rara-portfolio' => array( 
    			'singular_name'		  => __( 'Portfolio', 'the-conference-pro' ),
    			'general_name'		  => __( 'Portfolios', 'the-conference-pro' ),
    			'dashicon'			  => 'dashicons-portfolio',
    			'taxonomy'			  => 'rara_portfolio_categories',
    			'taxonomy_slug'		  => 'portfolio-category',
    			'has_archive'         => false,		
    			'exclude_from_search' => false,
    			'show_in_nav_menus'	  => true,
                'show_in_rest'        => true,
    			'supports' 			  => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt' ),
    			'rewrite' 			  => array( 'slug' => 'portfolio' ),
    			'hierarchical'		  => true,
    		),
        );
        return $posts;

    }   
endif;
add_filter( 'rc_get_posttype_array', 'the_conference_pro_custom_post_type' ); 

if( ! function_exists( 'the_conference_pro_create_hall_taxonomy' ) ) :
    /**
     *  Create Hall Taxonomy
     */
    function the_conference_pro_create_hall_taxonomy() {
    	register_taxonomy(
    		'rara_hall_categories',
    		'rara-schedule',
    		array(
                'label'             => __( 'Hall Categories', 'the-conference-pro' ),
                'rewrite'           => array( 'slug' => 'hall' ),
                'show_admin_column' => true,
                'hierarchical'      => false,
                'show_in_rest'      => true,
    		)
    	);
    }
endif;
add_action( 'init', 'the_conference_pro_create_hall_taxonomy' );

if( ! function_exists( 'the_conference_pro_add_hall_taxonomy_order_field' ) ) :
    /**
     * Filter to add hall taxonomy order field
     */
    function the_conference_pro_add_hall_taxonomy_order_field($taxonomy) { ?>
    	<div class="form-field hall-order">
            <label for="hall_order"><?php _e( 'Hall Order', 'the-conference-pro'); ?></label>
            <input type="text" name="hall_order" value="0" />
        </div><?php
    }
endif;
add_action( 'rara_hall_categories_add_form_fields', 'the_conference_pro_add_hall_taxonomy_order_field' );

if( ! function_exists( 'the_conference_pro_save_hall_order_meta' ) ) :
    /**
     * Filter to save hall taxonomy order meta field
     */
    function the_conference_pro_save_hall_order_meta( $term_id ){
        if( isset( $_POST['hall_order'] ) && '' !== $_POST['hall_order'] ){
            $hall_order = absint( $_POST['hall_order'] );
            add_term_meta( $term_id, 'hall_order', $hall_order, true );
        }else{
        	add_term_meta( $term_id, 'hall_order', 0, true );
        }
    }
endif;
add_action( 'created_rara_hall_categories', 'the_conference_pro_save_hall_order_meta' );

if( ! function_exists( 'the_conference_pro_edit_hall_order_field' ) ) :
    /**
     * Filter to edit hall taxonomy order meta field
     */
    function the_conference_pro_edit_hall_order_field( $term, $taxonomy ){
        // get current order
        $hall_order = get_term_meta( $term->term_id, 'hall_order', true );

        $hall_order = isset( $hall_order ) && '' != $hall_order ? $hall_order : 0;

        ?><tr class="form-field hall-order-wrap">
            <th scope="row"><label for="hall_order"><?php _e( 'Hall Order', 'the-conference-pro' ); ?></label></th>
            <td><input type="text" name="hall_order" value="<?php echo esc_attr( $hall_order );  ?>" /></td>
        </tr><?php
    }
endif;
add_action( 'rara_hall_categories_edit_form_fields', 'the_conference_pro_edit_hall_order_field', 10, 2 );

if( ! function_exists( 'the_conference_pro_update_hall_order_meta' ) ) :
    /**
     * Filter to edit hall taxonomy order meta field
     */
    function the_conference_pro_update_hall_order_meta( $term_id ){

        if( isset( $_POST['hall_order'] ) && '' !== $_POST['hall_order'] ){
            $hall_order = absint( $_POST['hall_order'] );
            update_term_meta( $term_id, 'hall_order', $hall_order );
        }else{
        	update_term_meta( $term_id, 'hall_order', 0 );
        }
    }
endif;
add_action( 'edited_rara_hall_categories', 'the_conference_pro_update_hall_order_meta');

if( ! function_exists( 'the_conference_pro_add_hall_order_column' ) ) :
    /**
     * Filter to add hall order column
     */
    function the_conference_pro_add_hall_order_column( $columns ){
        $columns['hall_order'] = __( 'Hall Order', 'the-conference-pro' );
        return $columns;
    }
endif;
add_filter('manage_edit-rara_hall_categories_columns', 'the_conference_pro_add_hall_order_column' );

if( ! function_exists( 'the_conference_pro_add_hall_order_column_content' ) ) :
     /**
     * Filter to add hall order column in admin screen
     */
    function the_conference_pro_add_hall_order_column_content( $content, $column_name, $term_id ){

        if( $column_name !== 'hall_order' ){
            return $content;
        }

        $term_id = absint( $term_id );
        $hall_order = get_term_meta( $term_id, 'hall_order', true );

        $content .= absint( $hall_order );

        return $content;
    }
endif;
add_filter('manage_rara_hall_categories_custom_column', 'the_conference_pro_add_hall_order_column_content', 10, 3 );

if( ! function_exists( 'the_conference_pro_add_hall_order_column_sortable' ) ) :
     /**
     * Filter to edit hall order column sortable in admin screen
     */
    function the_conference_pro_add_hall_order_column_sortable( $sortable ){
        $sortable[ 'hall_order' ] = 'hall_order';
        return $sortable;
    }
endif;
add_filter( 'manage_edit-rara_hall_categories_sortable_columns', 'the_conference_pro_add_hall_order_column_sortable' );


/**
 *  Term Meta order for Schedule Taxonomy
 */

if( ! function_exists( 'the_conference_pro_add_schedule_taxonomy_order_field' ) ) :
    /**
     * Filter to add schedule taxonomy order field
     */
    function the_conference_pro_add_schedule_taxonomy_order_field($taxonomy) { ?>
        <div class="form-field schedule-order">
            <label for="schedule_order"><?php _e( 'Schedule Order', 'the-conference-pro'); ?></label>
            <input type="text" name="schedule_order" value="0" />
        </div><?php
    }
endif;
add_action( 'rara_schedule_categories_add_form_fields', 'the_conference_pro_add_schedule_taxonomy_order_field' );

if( ! function_exists( 'the_conference_pro_save_schedule_order_meta' ) ) :
    /**
     * Filter to save schedule taxonomy order meta field
     */
    function the_conference_pro_save_schedule_order_meta( $term_id ){
        if( isset( $_POST['schedule_order'] ) && '' !== $_POST['schedule_order'] ){
            $schedule_order = absint( $_POST['schedule_order'] );
            add_term_meta( $term_id, 'schedule_order', $schedule_order, true );
        }else{
            add_term_meta( $term_id, 'schedule_order', 0, true );
        }
    }
endif;
add_action( 'created_rara_schedule_categories', 'the_conference_pro_save_schedule_order_meta' );

if( ! function_exists( 'the_conference_pro_edit_schedule_order_field' ) ) :
    /**
     * Filter to edit schedule taxonomy order meta field
     */
    function the_conference_pro_edit_schedule_order_field( $term, $taxonomy ){
        // get current order
        $schedule_order = get_term_meta( $term->term_id, 'schedule_order', true );

        $schedule_order = isset( $schedule_order ) && '' != $schedule_order ? $schedule_order : 0;

        ?><tr class="form-field schedule-order-wrap">
            <th scope="row"><label for="schedule_order"><?php _e( 'Schedule Order', 'the-conference-pro' ); ?></label></th>
            <td><input type="text" name="schedule_order" value="<?php echo esc_attr( $schedule_order );  ?>" /></td>
        </tr><?php
    }
endif;
add_action( 'rara_schedule_categories_edit_form_fields', 'the_conference_pro_edit_schedule_order_field', 10, 2 );

if( ! function_exists( 'the_conference_pro_update_schedule_order_meta' ) ) :
    /**
     * Filter to edit schedule taxonomy order meta field
     */
    function the_conference_pro_update_schedule_order_meta( $term_id ){

        if( isset( $_POST['schedule_order'] ) && '' !== $_POST['schedule_order'] ){
            $schedule_order = absint( $_POST['schedule_order'] );
            update_term_meta( $term_id, 'schedule_order', $schedule_order );
        }else{
            update_term_meta( $term_id, 'schedule_order', 0 );
        }
    }
endif;
add_action( 'edited_rara_schedule_categories', 'the_conference_pro_update_schedule_order_meta' );

if( ! function_exists( 'the_conference_pro_add_schedule_order_column' ) ) :
    /**
     * Filter to add schedule order column
     */
    function the_conference_pro_add_schedule_order_column( $columns ){
        $columns['schedule_order'] = __( 'Schedule Order', 'the-conference-pro' );
        return $columns;
    }
endif;
add_filter('manage_edit-rara_schedule_categories_columns', 'the_conference_pro_add_schedule_order_column' );

if( ! function_exists( 'the_conference_pro_add_schedule_order_column_content' ) ) :
     /**
     * Filter to add schedule order column in admin screen
     */
    function the_conference_pro_add_schedule_order_column_content( $content, $column_name, $term_id ){

        if( $column_name !== 'schedule_order' ){
            return $content;
        }

        $term_id = absint( $term_id );
        $schedule_order = get_term_meta( $term_id, 'schedule_order', true );

        $content .= absint( $schedule_order );

        return $content;
    }
endif;
add_filter('manage_rara_schedule_categories_custom_column', 'the_conference_pro_add_schedule_order_column_content', 10, 3 );

if( ! function_exists( 'the_conference_pro_add_schedule_order_column_sortable' ) ) :
     /**
     * Filter to edit schedule order column sortable in admin screen
     */
    function the_conference_pro_add_schedule_order_column_sortable( $sortable ){
        $sortable[ 'schedule_order' ] = 'schedule_order';
        return $sortable;
    }
endif;
add_filter( 'manage_edit-rara_schedule_categories_sortable_columns', 'the_conference_pro_add_schedule_order_column_sortable' );

/**
 * Schedule post meta sort option
 */
if( ! function_exists( 'the_conference_pro_columns_head' ) ) :
    /**
     * Adds a Order column header in the item list admin page.
     *
     * @param array $defaults
     * @return array
     */
    function the_conference_pro_columns_head( $defaults ){
           
        if( get_post_type() === 'rara-schedule' ){
            $defaults['schedule_order'] = __( 'Order', 'the-conference-pro' );
        }
        
        return $defaults;
    }
endif;
add_filter( 'manage_posts_columns', 'the_conference_pro_columns_head' );

if( ! function_exists( 'the_conference_pro_columns_content' ) ) :
    /**
     * @param string $column_name The name of the column to display.
     * @param int $post_ID The ID of the current post.
     */
    function the_conference_pro_columns_content( $column_name, $post_ID ){
        global $post;
        
        if( $column_name == 'schedule_order' ){
            echo $post->menu_order;
        } 
    }
endif;
add_action( 'manage_posts_custom_column', 'the_conference_pro_columns_content', 10, 2 );

if( ! function_exists( 'the_conference_pro_schedule_order_column_sortable' ) ) :
    /**
    * make column sortable
    */
    function the_conference_pro_schedule_order_column_sortable( $columns ){
        $columns['schedule_order'] = 'menu_order';
        return $columns;
    }
endif;
add_filter( 'manage_edit-schedule_sortable_columns', 'the_conference_pro_schedule_order_column_sortable' );