<?php
/**
 * The Conference Pro CPT Meta Box
 * 
 * @package The_Conference_Pro
 */

 add_action('add_meta_boxes', 'the_conference_pro_add_schedule_metabox');

function the_conference_pro_add_schedule_metabox(){    
    // Meta box to add addition details for "schedule"
    add_meta_box(
               'the_conference_pro_schedule_details', // $id
               __( 'Schedule Info', 'the-conference-pro' ), // $title
               'the_conference_pro_schedule_details_callback', // $callback
               'rara-schedule', // $post_type
               'normal', // $context
               'high'// $priority
    ); 
}

/**
 * Callback for Additional Info for schedules
*/
function the_conference_pro_schedule_details_callback(){

    global $post;
    wp_nonce_field( basename( __FILE__ ), 'cp_schedule_details_nonce' );
    
    $start_time  = get_post_meta( $post->ID, '_cp_schedule_start_time', true );
    $end_time    = get_post_meta( $post->ID, '_cp_schedule_end_time', true );
    $presentor = get_post_meta( $post->ID, '_cp_schedule_presentor', true );
    $designation = get_post_meta( $post->ID, '_cp_schedule_designation', true );
   
   
   ?>
    <div class="clearfix">
        <label class="bold-label float-left input_label" for="cp_schedule_start_time"><?php _e( 'Start Time', 'the-conference-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="time" id="cp_schedule_start_time" 
        class="date-cpt cp_schedule_start_time" name="cp_schedule_start_time" value="<?php echo esc_attr( $start_time ); ?>" /></div>
    </div>

    <div class="clearfix">
        <label class="bold-label float-left input_label" for="cp_schedule_end_time"><?php _e( 'End Time', 'the-conference-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="time" id="cp_schedule_end_time" class="date-cpt cp_schedule_end_time" name="cp_schedule_end_time" value="<?php echo esc_attr( $end_time ); ?>" /></div>
    </div>
    
    <div class="clearfix">
        <label class="bold-label float-left input_label" for="cp_schedule_presentor"><?php _e( 'Presentor', 'the-conference-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="text" id="cp_schedule_presentor" class="date-cpt cp_schedule_presentor" name="cp_schedule_presentor" value="<?php echo esc_attr( $presentor ); ?>" /></div>
    </div>
    
    <div class="clearfix">
        <label class="bold-label float-left input_label" for="cp_schedule_designation"><?php _e( 'Designation', 'the-conference-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="text" id="cp_schedule_designation" class="date-cpt cp_schedule_designation" name="cp_schedule_designation" value="<?php echo esc_attr( $designation ); ?>" /></div>
    </div>

    <?php
}

function the_conference_pro_save_schedule_details( $post_id ){
    // Check if our nonce is set.
    if ( ! isset( $_POST['cp_schedule_details_nonce'] ) || ! wp_verify_nonce( $_POST['cp_schedule_details_nonce'], basename( __FILE__ ) ) ) {
        return;
    }

    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {
        if ( ! current_user_can( 'edit_page', $post_id ) ) return;      
    } else {
        if ( ! current_user_can( 'edit_post', $post_id ) ) return;
    }
    
    // Sanitize user input.
    $start_time  = esc_html( $_POST['cp_schedule_start_time'] ); 
    $end_time    = esc_html( $_POST['cp_schedule_end_time'] );       
    $presentor = esc_html( $_POST['cp_schedule_presentor'] );       
    $designation = esc_html( $_POST['cp_schedule_designation'] );       
    
 
    // Update the meta field in the database.
    update_post_meta( $post_id, '_cp_schedule_start_time', $start_time );
    update_post_meta( $post_id, '_cp_schedule_end_time', $end_time );
    update_post_meta( $post_id, '_cp_schedule_presentor', $presentor );
    update_post_meta( $post_id, '_cp_schedule_designation', $designation );
    
}
add_action( 'save_post', 'the_conference_pro_save_schedule_details' );