<?php
/**
 * Customizer Control: the-conference-pro-customizer-reset
 *
 * @package The_Conference_Pro
*/

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'The_Conference_Pro_Customizer_Reset_Control' ) ) {
	/**
	 * Migration control.
    */
	class The_Conference_Pro_Customizer_Reset_Control extends Wp_Customize_Control {

		public $type = 'the-conference-pro-customizer-reset';
        
        public function enqueue() {
			wp_enqueue_style( 'jquery-confirm', get_template_directory_uri() . '/inc/css/jquery-confirm.min.css', array(), '3.3.4' );
            wp_enqueue_script( 'jquery-confirm', get_template_directory_uri() . '/inc/js/jquery-confirm.min.js', array( 'jquery' ), '3.3.4', true );
            wp_enqueue_style( 'the-conference-pro-customizer-reset', get_template_directory_uri() . '/inc/custom-controls/reset/customizer-reset.css', array(), THE_CONFERENCE_PRO_THEME_VERSION );
            wp_enqueue_script( 'the-conference-pro-customizer-reset', get_template_directory_uri() . '/inc/custom-controls/reset/customizer-reset.js', array( 'jquery' ), THE_CONFERENCE_PRO_THEME_VERSION, true );
            wp_localize_script( 'the-conference-pro-customizer-reset', 'The_Conference_Pro_Reset', array(
				'title'   => __( 'ARE YOU SURE?', 'the-conference-pro' ),
                'content' => __( '<p>Pressing <strong>"Y"</strong> will remove all customizations ever made via customizer in this theme.</p><strong class="danger_info">!!! THIS ACTION IS IRREVERSIBLE !!!</strong><p>Please click <strong>"NO"</strong> or press <strong>"N"</strong> if you do not wish to do so.</p>', 'the-conference-pro' ),
				'nonce'   => wp_create_nonce( 'the-conference-pro-customizer-reset' )
			) );
		}
        
		public function render_content(){
            if( $this->label ){
                echo '<span class="customize-reset-title customize-control-title">';
                echo esc_html( $this->label );
                echo '</span>';
            }
    
    		if( $this->description ){
    			echo '<span class="customize-reset-description customize-control-description">';
    			echo wp_kses_post( $this->description );
    			echo '</span>';
    		}
            ?>
            <div id="customizer_reset_btn">
				<button type="button" class="button button-secondary" id="customizer_reset"><?php esc_html_e( 'Reset !!!', 'the-conference-pro' ); ?></button>	
			</div>
            <?php
        }
	}
}