<?php
/**
 * The Conference Pro Customizer Typography Control
 *
 * @package The_Conference_Pro
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'The_Conference_Pro_Typography_Control' ) ) {
    
    class The_Conference_Pro_Typography_Control extends WP_Customize_Control {
    
    	public $tooltip = '';
    	public $js_vars = array();
    	public $output = array();
    	public $option_type = 'theme_mod';
    	public $type = 'typography';
    
    	/**
    	 * Refresh the parameters passed to the JavaScript via JSON.
    	 *
    	 * @access public
    	 * @return void
    	 */
    	public function to_json() {
    		parent::to_json();
    
    		if ( isset( $this->default ) ) {
    			$this->json['default'] = $this->default;
    		} else {
    			$this->json['default'] = $this->setting->default;
    		}
    		$this->json['js_vars'] = $this->js_vars;
    		$this->json['output']  = $this->output;
    		$this->json['value']   = $this->value();
    		$this->json['choices'] = $this->choices;
    		$this->json['link']    = $this->get_link();
    		$this->json['tooltip'] = $this->tooltip;
    		$this->json['id']      = $this->id;
    		$this->json['l10n']    = apply_filters( 'the_conference_pro_il8n_strings', array(
    			'on'                 => esc_attr__( 'ON', 'the-conference-pro' ),
    			'off'                => esc_attr__( 'OFF', 'the-conference-pro' ),
    			'all'                => esc_attr__( 'All', 'the-conference-pro' ),
    			'cyrillic'           => esc_attr__( 'Cyrillic', 'the-conference-pro' ),
    			'cyrillic-ext'       => esc_attr__( 'Cyrillic Extended', 'the-conference-pro' ),
    			'devanagari'         => esc_attr__( 'Devanagari', 'the-conference-pro' ),
    			'greek'              => esc_attr__( 'Greek', 'the-conference-pro' ),
    			'greek-ext'          => esc_attr__( 'Greek Extended', 'the-conference-pro' ),
    			'khmer'              => esc_attr__( 'Khmer', 'the-conference-pro' ),
    			'latin'              => esc_attr__( 'Latin', 'the-conference-pro' ),
    			'latin-ext'          => esc_attr__( 'Latin Extended', 'the-conference-pro' ),
    			'vietnamese'         => esc_attr__( 'Vietnamese', 'the-conference-pro' ),
    			'hebrew'             => esc_attr__( 'Hebrew', 'the-conference-pro' ),
    			'arabic'             => esc_attr__( 'Arabic', 'the-conference-pro' ),
    			'bengali'            => esc_attr__( 'Bengali', 'the-conference-pro' ),
    			'gujarati'           => esc_attr__( 'Gujarati', 'the-conference-pro' ),
    			'tamil'              => esc_attr__( 'Tamil', 'the-conference-pro' ),
    			'telugu'             => esc_attr__( 'Telugu', 'the-conference-pro' ),
    			'thai'               => esc_attr__( 'Thai', 'the-conference-pro' ),
    			'serif'              => _x( 'Serif', 'font style', 'the-conference-pro' ),
    			'sans-serif'         => _x( 'Sans Serif', 'font style', 'the-conference-pro' ),
    			'monospace'          => _x( 'Monospace', 'font style', 'the-conference-pro' ),
    			'font-family'        => esc_attr__( 'Font Family', 'the-conference-pro' ),
    			'font-size'          => esc_attr__( 'Font Size', 'the-conference-pro' ),
    			'font-weight'        => esc_attr__( 'Font Weight', 'the-conference-pro' ),
    			'line-height'        => esc_attr__( 'Line Height', 'the-conference-pro' ),
    			'font-style'         => esc_attr__( 'Font Style', 'the-conference-pro' ),
    			'letter-spacing'     => esc_attr__( 'Letter Spacing', 'the-conference-pro' ),
    			'text-align'         => esc_attr__( 'Text Align', 'the-conference-pro' ),
    			'text-transform'     => esc_attr__( 'Text Transform', 'the-conference-pro' ),
    			'none'               => esc_attr__( 'None', 'the-conference-pro' ),
    			'uppercase'          => esc_attr__( 'Uppercase', 'the-conference-pro' ),
    			'lowercase'          => esc_attr__( 'Lowercase', 'the-conference-pro' ),
    			'top'                => esc_attr__( 'Top', 'the-conference-pro' ),
    			'bottom'             => esc_attr__( 'Bottom', 'the-conference-pro' ),
    			'left'               => esc_attr__( 'Left', 'the-conference-pro' ),
    			'right'              => esc_attr__( 'Right', 'the-conference-pro' ),
    			'center'             => esc_attr__( 'Center', 'the-conference-pro' ),
    			'justify'            => esc_attr__( 'Justify', 'the-conference-pro' ),
    			'color'              => esc_attr__( 'Color', 'the-conference-pro' ),
    			'select-font-family' => esc_attr__( 'Select a font-family', 'the-conference-pro' ),
    			'variant'            => esc_attr__( 'Variant', 'the-conference-pro' ),
    			'style'              => esc_attr__( 'Style', 'the-conference-pro' ),
    			'size'               => esc_attr__( 'Size', 'the-conference-pro' ),
    			'height'             => esc_attr__( 'Height', 'the-conference-pro' ),
    			'spacing'            => esc_attr__( 'Spacing', 'the-conference-pro' ),
    			'ultra-light'        => esc_attr__( 'Ultra-Light 100', 'the-conference-pro' ),
    			'ultra-light-italic' => esc_attr__( 'Ultra-Light 100 Italic', 'the-conference-pro' ),
    			'light'              => esc_attr__( 'Light 200', 'the-conference-pro' ),
    			'light-italic'       => esc_attr__( 'Light 200 Italic', 'the-conference-pro' ),
    			'book'               => esc_attr__( 'Book 300', 'the-conference-pro' ),
    			'book-italic'        => esc_attr__( 'Book 300 Italic', 'the-conference-pro' ),
    			'regular'            => esc_attr__( 'Normal 400', 'the-conference-pro' ),
    			'italic'             => esc_attr__( 'Normal 400 Italic', 'the-conference-pro' ),
    			'medium'             => esc_attr__( 'Medium 500', 'the-conference-pro' ),
    			'medium-italic'      => esc_attr__( 'Medium 500 Italic', 'the-conference-pro' ),
    			'semi-bold'          => esc_attr__( 'Semi-Bold 600', 'the-conference-pro' ),
    			'semi-bold-italic'   => esc_attr__( 'Semi-Bold 600 Italic', 'the-conference-pro' ),
    			'bold'               => esc_attr__( 'Bold 700', 'the-conference-pro' ),
    			'bold-italic'        => esc_attr__( 'Bold 700 Italic', 'the-conference-pro' ),
    			'extra-bold'         => esc_attr__( 'Extra-Bold 800', 'the-conference-pro' ),
    			'extra-bold-italic'  => esc_attr__( 'Extra-Bold 800 Italic', 'the-conference-pro' ),
    			'ultra-bold'         => esc_attr__( 'Ultra-Bold 900', 'the-conference-pro' ),
    			'ultra-bold-italic'  => esc_attr__( 'Ultra-Bold 900 Italic', 'the-conference-pro' ),
    			'invalid-value'      => esc_attr__( 'Invalid Value', 'the-conference-pro' ),
    		) );
    
    		$defaults = array( 'font-family'=> false );
    
    		$this->json['default'] = wp_parse_args( $this->json['default'], $defaults );
    	}
    
    	/**
    	 * Enqueue scripts and styles.
    	 *
    	 * @access public
    	 * @return void
    	 */
    	public function enqueue() {
    		wp_enqueue_style( 'the-conference-pro-typography', get_template_directory_uri() . '/inc/custom-controls/typography/typography.css', null );
            
            wp_enqueue_script( 'jquery-ui-core' );
    		wp_enqueue_script( 'jquery-ui-tooltip' );
    		wp_enqueue_script( 'jquery-stepper-min-js' );
    		wp_enqueue_script( 'the-conference-pro-selectize', get_template_directory_uri() . '/inc/js/selectize.js', array( 'jquery' ), false, true );
    		wp_enqueue_script( 'the-conference-pro-typography', get_template_directory_uri() . '/inc/custom-controls/typography/typography.js', array( 'jquery', 'the-conference-pro-selectize' ), false, true );
    
    		$google_fonts   = The_Conference_Pro_Fonts::get_google_fonts();
    		$standard_fonts = The_Conference_Pro_Fonts::get_standard_fonts();
    		$all_variants   = The_Conference_Pro_Fonts::get_all_variants();
    
    		$standard_fonts_final = array();
    		foreach ( $standard_fonts as $key => $value ) {
    			$standard_fonts_final[] = array(
    				'family'      => $value['stack'],
    				'label'       => $value['label'],
    				'is_standard' => true,
    				'variants'    => array(
    					array(
    						'id'    => 'regular',
    						'label' => $all_variants['regular'],
    					),
    					array(
    						'id'    => 'italic',
    						'label' => $all_variants['italic'],
    					),
    					array(
    						'id'    => '700',
    						'label' => $all_variants['700'],
    					),
    					array(
    						'id'    => '700italic',
    						'label' => $all_variants['700italic'],
    					),
    				),
    			);
    		}
    
    		$google_fonts_final = array();
    
    		if ( is_array( $google_fonts ) ) {
    			foreach ( $google_fonts as $family => $args ) {
    				$label    = ( isset( $args['label'] ) ) ? $args['label'] : $family;
    				$variants = ( isset( $args['variants'] ) ) ? $args['variants'] : array( 'regular', '700' );
    
    				$available_variants = array();
    				foreach ( $variants as $variant ) {
    					if ( array_key_exists( $variant, $all_variants ) ) {
    						$available_variants[] = array( 'id' => $variant, 'label' => $all_variants[ $variant ] );
    					}
    				}
    
    				$google_fonts_final[] = array(
    					'family'   => $family,
    					'label'    => $label,
    					'variants' => $available_variants
    				);
    			}
    		}
    
    		$final = array_merge( $standard_fonts_final, $google_fonts_final );
    		wp_localize_script( 'the-conference-pro-typography', 'all_fonts', $final );
    	}
    
    	/**
    	 * An Underscore (JS) template for this control's content (but not its container).
    	 *
    	 * Class variables for this control class are available in the `data` JS object;
    	 * export custom variables by overriding {@see WP_Customize_Control::to_json()}.
    	 *
    	 * I put this in a separate file because PhpStorm didn't like it and it fucked with my formatting.
    	 *
    	 * @see    WP_Customize_Control::print_template()
    	 *
    	 * @access protected
    	 * @return void
    	 */
    	protected function content_template(){ ?>
    		<# if ( data.tooltip ) { #>
                <a href="#" class="tooltip hint--left" data-hint="{{ data.tooltip }}"><span class='dashicons dashicons-info'></span></a>
            <# } #>
            
            <label class="customizer-text">
                <# if ( data.label ) { #>
                    <span class="customize-control-title">{{{ data.label }}}</span>
                <# } #>
                <# if ( data.description ) { #>
                    <span class="description customize-control-description">{{{ data.description }}}</span>
                <# } #>
            </label>
            
            <div class="wrapper">
                <# if ( data.default['font-family'] ) { #>
                    <# if ( '' == data.value['font-family'] ) { data.value['font-family'] = data.default['font-family']; } #>
                    <# if ( data.choices['fonts'] ) { data.fonts = data.choices['fonts']; } #>
                    <div class="font-family">
                        <h5>{{ data.l10n['font-family'] }}</h5>
                        <select id="the-conference-pro-typography-font-family-{{{ data.id }}}" placeholder="{{ data.l10n['select-font-family'] }}"></select>
                    </div>
                    <div class="variant the-conference-pro-variant-wrapper">
                        <h5>{{ data.l10n['style'] }}</h5>
                        <select class="variant" id="the-conference-pro-typography-variant-{{{ data.id }}}"></select>
                    </div>
                <# } #>   
                
            </div>
            <?php
    	}    
        public function render_content() {
            // intentionally empty
        }
    }
}