<?php
/**
 * Active Callback
 * 
 * @package The_Conference_Pro
*/

/**
 * Active Callback for Banner Slider
*/
function the_conference_pro_banner_ac( $control ){
    $banner         = $control->manager->get_setting( 'ed_banner_section' )->value();
    $slider_type    = $control->manager->get_setting( 'slider_type' )->value();
    $ed_event_timer = $control->manager->get_setting( 'ed_banner_event_timer' )->value();

    $control_id  = $control->id;
    
    if ( $control_id == 'header_image' && ( $banner == 'static_banner' || $banner == 'static_nl_banner' ) ) return true;
    if ( $control_id == 'header_video' && ( $banner == 'static_banner' || $banner == 'static_nl_banner' ) ) return true;
    if ( $control_id == 'external_header_video' && ( $banner == 'static_banner' || $banner == 'static_nl_banner' ) ) return true;
    if ( $control_id == 'banner_title' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_subtitle' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_label_one' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_link_one' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_label_two' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_link_two' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'ed_banner_event_timer' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_event_timer' && $banner == 'static_banner' && $ed_event_timer ) return true;
    if ( $control_id == 'banner_event_time' && $banner == 'static_banner' && $ed_event_timer ) return true;
    if ( $control_id == 'banner_timer_note' && $banner == 'static_banner' && $ed_event_timer ) return true;
    if ( $control_id == 'banner_newsletter' && $banner == 'static_nl_banner' ) return true;
    if ( $control_id == 'banner_newsletter_note' && $banner == 'static_nl_banner' ) return true;
    
    if ( $control_id == 'slider_type' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_auto' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_loop' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_caption' && $banner == 'slider_banner' ) return true;          
    if ( $control_id == 'slider_readmore' && $banner == 'slider_banner' ) return true;    
    if ( $control_id == 'slider_cat' && $banner == 'slider_banner' && $slider_type == 'cat' ) return true;
    if ( $control_id == 'no_of_slides' && $banner == 'slider_banner' && $slider_type == 'latest_posts' ) return true;
    if ( $control_id == 'slider_pages' && $banner == 'slider_banner' && $slider_type == 'pages' ) return true;
    if ( $control_id == 'slider_custom' && $banner == 'slider_banner' && $slider_type == 'custom' ) return true;
    if ( $control_id == 'slider_full_image' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_animation' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'hr' && $banner == 'slider_banner' ) return true;
    
    return false;
}

/**
 * Active Callback for onepage menu option
*/
function the_conference_pro_onepage_menu_ac( $control ){
    $ed_one_page = $control->manager->get_setting( 'ed_one_page' )->value();
    $control_id  = $control->id;
    
    if ( $control_id == 'ed_home_link' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_about' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_stat_counter' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_conference' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_speakers' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_schedule' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_ticket' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_testimonial' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_timer_cta' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_sponsor' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_cta' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_faq' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_gallery' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_blog' && $ed_one_page == true ) return true; 
    if ( $control_id == 'label_contact' && $ed_one_page == true ) return true; 
    
    return false;
}

/**
 * Active Callback for Blog View All Button
*/
function the_conference_pro_blog_view_all_ac(){
    $blog = get_option( 'page_for_posts' );
    if( $blog ) return true;
    
    return false; 
}

/**
 * Active Callback for Body Background
*/
function the_conference_pro_body_bg_choice( $control ){
    
    $body_bg    = $control->manager->get_setting( 'body_bg' )->value();
    $control_id = $control->id;
         
    if ( $control_id == 'background_image' && $body_bg == 'image' ) return true;
    if ( $control_id == 'background_preset' && $body_bg == 'image' ) return true;
    if ( $control_id == 'background_position' && $body_bg == 'image' ) return true;
    if ( $control_id == 'background_size' && $body_bg == 'image' ) return true;
    if ( $control_id == 'background_repeat' && $body_bg == 'image' ) return true;
    if ( $control_id == 'background_attachment' && $body_bg == 'image' ) return true;
    if ( $control_id == 'bg_pattern' && $body_bg == 'pattern' ) return true;
    
    return false;
}

/**
 * Active Callback for post/page
*/
function the_conference_pro_post_page_ac( $control ){
    
    $ed_related = $control->manager->get_setting( 'ed_related' )->value();
    $control_id = $control->id;
    
    if ( $control_id == 'related_post_title' && $ed_related == true ) return true;
    if ( $control_id == 'related_taxonomy' && $ed_related == true ) return true;
    
    return false;
}

/**
 * Active Callback for pagination
*/
function the_conference_pro_loading_ac( $control ){
    
    $pagination_type = $control->manager->get_setting( 'pagination_type' )->value();
    
    if ( $pagination_type == 'load_more' ) return true;
    
    return false;
}

/**
 * Active Callback for Shop page description
*/
function the_conference_pro_shop_description_ac( $control ){
    $ed_shop_archive_desc = $control->manager->get_setting( 'ed_shop_archive_description' )->value();
    $control_id = $control->id;
    
    if( $control_id == 'shop_archive_description' && $ed_shop_archive_desc == true && is_woocommerce_activated() ) return true;
    
    return false;
}


/**
 * Active Callback
 */
function the_conference_pro_aboutpage_testimonial_section_ac( $control ){
    $testimonial_template_link = the_conference_pro_get_template_page_url( 'templates/testimonial.php' );
    $control_id         = $control->id;

    // Team view all label
    if ( $control_id == 'about_testimonial_viewall_label' && $testimonial_template_link ) return true;

    return false;
}

/**
 * Active Callback for About Page Template
*/
function the_conference_pro_about_template_ac( $control ){
    $ed_event_timer = $control->manager->get_setting( 'ed_about_event_timer' )->value();
    $control_id  = $control->id;
    
    if ( $control_id == 'about_timer_cta_event_time'  && $ed_event_timer ) return true;
    if ( $control_id == 'about_cta_event_time'  && $ed_event_timer ) return true;
    if ( $control_id == 'aboutcta_timer_note'  && $ed_event_timer ) return true;

    return false;
}

/**
 * Active Callback
 */
function the_conference_pro_frontpage_schedule_section_ac( $control ){
    $testimonial_template_link = the_conference_pro_get_template_page_url( 'templates/schedule.php' );
    $control_id         = $control->id;

    // Schedule view all
    if ( $control_id == 'schedule_section_readmore' && $testimonial_template_link ) return true;

    return false;
}

/**
 * Active Callback
 */
function the_conference_pro_frontpage_ticket_section_ac( $control ){
    $ticket_template_link = the_conference_pro_get_template_page_url( 'templates/ticket.php' );
    $control_id         = $control->id;

    // Team view all label
    if ( $control_id == 'ticket_viewall_label' && $ticket_template_link ) return true;

    return false;
}

/**
 * Active Callback
 */
function the_conference_pro_frontpage_gallery_section_ac( $control ){
    $gallery_template_link = the_conference_pro_get_template_page_url( 'templates/gallery.php' );
    $control_id         = $control->id;

    // gallery view all
    if ( $control_id == 'gallery_btn_label' && $gallery_template_link ) return true;

    return false;
}

/**
 * Active Callback
 */
function the_conference_pro_frontpage_testimonial_section_ac( $control ){
    $testimonial_template_link = the_conference_pro_get_template_page_url( 'templates/testimonial.php' );
    $control_id         = $control->id;

    // Team view all label
    if ( $control_id == 'testimonial_viewall_label' && $testimonial_template_link ) return true;

    return false;
}

/**
 * Active Callback for Timer CTA Section
 */
function the_conference_pro_timer_cta_ac( $control ){
    $ed_event_timer = $control->manager->get_setting( 'ed_timer_cta_event_time' )->value();
    $control_id  = $control->id;
    
    if ( $control_id == 'timer_cta_event_time' && $ed_event_timer ) return true;
    if ( $control_id == 'cta_event_time' && $ed_event_timer ) return true;
    if ( $control_id == 'cta_timer_note' && $ed_event_timer ) return true;

    return false;
}

/**
 * Active Callback for faq Section
 */
function the_conference_pro_frontpage_faq_section_ac( $control ){
    $faq_template_link = the_conference_pro_get_template_page_url( 'templates/faq.php' );
    $control_id         = $control->id;

    // FAQ view all label
    if ( $control_id == 'faq_viewall_label' && $faq_template_link ) return true;

    return false;
}

/**
 * Active Callback for newsletter settings
 */
function the_conference_pro_newsletter_setting_ac( $control ){
    $ed_newsletter = $control->manager->get_setting( 'ed_newsletter' )->value();
    $ed_gradient   = $control->manager->get_setting( 'ed_newsletter_gradient' )->value();
    $control_id    = $control->id;

    // FAQ view all label
    if ( $control_id == 'ed_newsletter_gradient' && $ed_newsletter ) return true;
    if ( $control_id == 'newsletter_shortcode' && $ed_newsletter ) return true;

    return false;
}

/**
 * Active Callback
 */
function the_conference_pro_header_section_ac( $control ){
    $custom_link_type = $control->manager->get_setting( 'custom_link_option' )->value();
    $control_id       = $control->id;

    // Custom Link
    if ( $control_id == 'custom_link_label'  && 'custom' == $custom_link_type ) return true;
    if ( $control_id == 'custom_link'  && 'custom' == $custom_link_type ) return true;

    if ( $control_id == 'custom_link_page'  && 'page' == $custom_link_type ) return true;
    if ( $control_id == 'ed_custom_link_tab'  && 'custom' == $custom_link_type ) return true;

    return false;
}
