<?php
/**
 * The Conference Pro Theme Customizer
 *
 * @package The_Conference_Pro
 */

/**
 * Requiring customizer panels & sections
*/
$the_conference_pro_panels       = array( 'appearance', 'layout', 'typography', 'home', 'about', 'schedule', 'gallery', 'speaker', 'ticket', 'sponsor', 'testimonial', 'venue', 'faq', 'contact', 'general' );
$the_conference_pro_sections     = array( 'site', 'info', 'footer' );
$the_conference_pro_sub_sections = array(
    'appearance' => array( 'background', 'color' ),
    'layout'     => array( 'header', 'blog', 'general', 'pagination' ),
    'typography' => array( 'body', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' ),
    'home'       => array( 'banner', 'stat-counter', 'schedule', 'ticket', 'testimonial', 'timer-cta', 'faq', 'gallery', 'blog', 'sort', 'onepage' ),
    'about'      => array( 'stat-counter', 'testimonial', 'timer-cta' ),
    'general'    => array( 'performance', 'sidebar', 'header', 'share', 'seo', 'post-page', 'newsletter', 'misc', 'google-analytics' ),    
);

foreach( $the_conference_pro_sections as $s ){
    require get_template_directory() . '/inc/customizer/sections/' . $s . '.php';
}

foreach( $the_conference_pro_panels as $p ){
   require get_template_directory() . '/inc/customizer/panels/' . $p . '.php';
}

foreach( $the_conference_pro_sub_sections as $k => $v ){
    foreach( $v as $w ){        
        require get_template_directory() . '/inc/customizer/panels/' . $k . '/' . $w . '.php';
    }
}

/**
 * Sanitization Functions
*/
require get_template_directory() . '/inc/customizer/sanitization-functions.php';

/**
 * Active Callbacks
*/
require get_template_directory() . '/inc/customizer/active-callback.php';

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function the_conference_pro_customize_preview_js() {
	wp_enqueue_script( 'the-conference-pro-customizer', get_template_directory_uri() . '/inc/js/customizer.js', array( 'customize-preview' ), THE_CONFERENCE_PRO_THEME_VERSION, true );
}
add_action( 'customize_preview_init', 'the_conference_pro_customize_preview_js' );

function the_conference_pro_customize_script(){
    $array = array(
        'home'     => get_home_url(),
        'about'    => the_conference_pro_get_page_template_url( 'templates/about.php' ),
        'gallery'  => the_conference_pro_get_page_template_url( 'templates/gallery.php' ),
        'schedule' => the_conference_pro_get_page_template_url( 'templates/schedule.php' ),
    );
    wp_enqueue_style( 'the-conference-pro-customize', get_template_directory_uri() . '/inc/css/customize.css', array(), THE_CONFERENCE_PRO_THEME_VERSION );
    wp_enqueue_script( 'the-conference-pro-customize', get_template_directory_uri() . '/inc/js/customize.js', array( 'jquery', 'customize-controls' ), THE_CONFERENCE_PRO_THEME_VERSION, true );
    wp_localize_script( 'the-conference-pro-customize', 'the_conference_pro_cdata', $array );
}
add_action( 'customize_controls_enqueue_scripts', 'the_conference_pro_customize_script' );

/*
 * Notifications in customizer
 */
require get_template_directory() . '/inc/customizer-plugin-recommend/customizer-notice/class-customizer-notice.php';

require get_template_directory() . '/inc/customizer-plugin-recommend/plugin-install/class-plugin-install-helper.php';

require get_template_directory() . '/inc/customizer-plugin-recommend/plugin-install/class-plugin-recommend.php';

$config_customizer = array(
	'recommended_plugins' => array(
		//change the slug for respective plugin recomendation
        'raratheme-companion' => array(
			'recommended' => true,
			'description' => sprintf(
				/* translators: %s: plugin name */
				esc_html__( 'If you want to take full advantage of the features this theme has to offer, please install and activate %s plugin.', 'the-conference-pro' ), '<strong>RaraTheme Companion</strong>'
			),
		),
	),
	'recommended_plugins_title' => esc_html__( 'Recommended Plugin', 'the-conference-pro' ),
	'install_button_label'      => esc_html__( 'Install and Activate', 'the-conference-pro' ),
	'activate_button_label'     => esc_html__( 'Activate', 'the-conference-pro' ),
	'deactivate_button_label'   => esc_html__( 'Deactivate', 'the-conference-pro' ),
);
The_Conference_Pro_Customizer_Notice::init( apply_filters( 'the_conference_pro_customizer_notice_array', $config_customizer ) );