<?php
/**
 * About Page Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_about( $wp_customize ) {
    
    $wp_customize->add_panel( 
        'about_page_settings', 
        array(
            'title'       => __( 'About Page Settings', 'the-conference-pro' ),
            'priority'    => 45,
            'capability'  => 'edit_theme_options',
            'description' => __( 'About Page Template Settings.', 'the-conference-pro' ),
        ) 
    );
    
    /** Sort About Page Section */
    $wp_customize->add_section(
        'sort_about_page_settings',
        array(
            'title'    => __( 'Sort About Page Section', 'the-conference-pro' ),
            'priority' => 80,
            'panel'    => 'about_page_settings',
        )
    );
    
    /** Sort About Page Section Section */
    $wp_customize->add_setting(
		'about_sort', 
		array(
			'default' => array( 'intro', 'experience', 'speakers', 'stat-counter', 'testimonial', 'timer-cta', 'sponsor' ),
			'sanitize_callback' => 'the_conference_pro_sanitize_sortable',						
		)
	);

	$wp_customize->add_control(
		new The_Conference_Pro_Sortable_Control(
			$wp_customize,
			'about_sort',
			array(
				'section'     => 'sort_about_page_settings',
				'label'       => __( 'Sort Sections', 'the-conference-pro' ),
				'description' => __( 'Sort or toggle about page sections.', 'the-conference-pro' ),
				'choices'     => array(
                    'intro'        => __( 'Intro Section', 'the-conference-pro' ),
                    'experience'   => __( 'Experience Section', 'the-conference-pro' ),
                    'speakers'     => __( 'Speakers Section', 'the-conference-pro' ),
                    'stat-counter' => __( 'Stat Counter Section', 'the-conference-pro' ),
                    'testimonial'  => __( 'Testimonial Section', 'the-conference-pro' ),
                    'timer-cta'    => __( 'Call to Action Section', 'the-conference-pro' ),
                    'sponsor'      => __( 'Sponsor Section', 'the-conference-pro' ),
            	),
			)
		)
	);
     
}
add_action( 'customize_register', 'the_conference_pro_customize_register_about' );