<?php
/**
 * About Template Stat Counter Section
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_about_template_stat_counter( $wp_customize ){

	/** Stat Counter Section */
    $wp_customize->add_section(
        'about_stat_counter_section',
        array(
            'title'    => __( 'About Stat Counter Section', 'the-conference-pro' ),
            'priority' => 35,
            'panel'    => 'about_page_settings',
        )
    );

    /** Background Image */
    $wp_customize->add_setting(
        'about_stat_counter_bg_image',
        array(
            'default'           => get_template_directory_uri() . '/images/counter-bg.jpg',
            'sanitize_callback' => 'the_conference_pro_sanitize_image',
        )
    );
    
    $wp_customize->add_control(
       new WP_Customize_Image_Control(
           $wp_customize,
           'about_stat_counter_bg_image',
           array(
               'label'    => __( 'Background Image', 'the-conference-pro' ),
               'section'  => 'about_stat_counter_section',
               'priority' => -1
           )
       )
    );

    $about_stat_counter_section = $wp_customize->get_section( 'sidebar-widgets-about-stat-counter' );

    if ( ! empty( $about_stat_counter_section ) ) {
        $about_stat_counter_section->panel = 'about_page_settings';
        $about_stat_counter_section->priority = 35;
        $wp_customize->get_control( 'about_stat_counter_bg_image' )->section  = 'sidebar-widgets-about-stat-counter';
    }
}
add_action( 'customize_register', 'the_conference_pro_customize_register_about_template_stat_counter' );