<?php
/**
 * About Template Testimonial Section
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_about_template_testimonial( $wp_customize ){

	/** Testomonial Section */
    $wp_customize->add_section(
        'about_testimonial_section',
        array(
            'title'    => __( 'About Testomonial Section', 'the-conference-pro' ),
            'priority' => 30,
            'panel'    => 'about_page_settings',
        )
    );

    // view all button label.
    $wp_customize->add_setting(
        'about_testimonial_viewall_label',
        array(
            'default'           => __( 'SEE ALL TESTIMONIALS', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field', 
            'transport'         => 'postMessage'
        )
    );
        
    $wp_customize->add_control(
        'about_testimonial_viewall_label',
        array(
            'section'         => 'about_testimonial_section',
            'priority'        => 100,
            'label'           => esc_html__( 'View All Label', 'the-conference-pro' ),
            'active_callback' => 'the_conference_pro_aboutpage_testimonial_section_ac'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'about_testimonial_viewall_label', array(
        'selector' => '#about_testimonial_section .container .btn-wrap a.btn-filled',
        'render_callback' => 'the_conference_pro_about_template_testimonial_viewall_label',
    ) );

    $about_testimonial_section = $wp_customize->get_section( 'sidebar-widgets-about-testimonial' );

    if ( ! empty( $about_testimonial_section ) ) {
        $about_testimonial_section->panel = 'about_page_settings';
        $about_testimonial_section->priority = 50;
        $wp_customize->get_control( 'about_testimonial_viewall_label' )->section  = 'sidebar-widgets-about-testimonial';
    }
}
add_action( 'customize_register', 'the_conference_pro_customize_register_about_template_testimonial' );
