<?php
/**
 * About Template Timer CTA Section
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_about_template_timer_cta( $wp_customize ){

    /** Timer CTA Section */
    $wp_customize->add_section(
        'about_timer_cta_section',
        array(
            'title'    => __( 'About Timer CTA Section', 'the-conference-pro' ),
            'priority' => 35,
            'panel'    => 'about_page_settings',
        )
    );

    /** Blog title */
    $wp_customize->add_setting(
        'about_timer_cta_title',
        array(
            'default'           => __( 'Hurry Up For Early Bird Tickets!', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'about_timer_cta_title',
        array(
            'section'         => 'about_timer_cta_section',
            'label'           => __( 'Title', 'the-conference-pro' ),
        )
    );

    // Selective refresh.
    $wp_customize->selective_refresh->add_partial( 'about_timer_cta_title', array(
        'selector'            => '#about_timer_cta_section .container h2.section-title',
        'render_callback'     => 'the_conference_pro_about_timer_cta_title_selective_refresh',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
    ) );

    /** Blog description */
    $wp_customize->add_setting(
        'about_timer_cta_description',
        array(
            'default'           => __( 'See what other people are saying about us', 'the-conference-pro' ),
            'sanitize_callback' => 'wp_kses_post',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'about_timer_cta_description',
        array(
            'section'         => 'about_timer_cta_section',
            'label'           => __( 'Description', 'the-conference-pro' ),
            'type'            => 'textarea',
        )
    ); 

    // Selective refresh for blog description.
    $wp_customize->selective_refresh->add_partial( 'about_timer_cta_description', array(
        'selector'            => '#about_timer_cta_section .container .section-desc',
        'render_callback'     => 'the_conference_pro_about_timer_cta_description_selective_refresh',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
    ) );

    /** Enable Banner Timer */
    $wp_customize->add_setting(
        'ed_about_event_timer',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control( 
            $wp_customize,
            'ed_about_event_timer',
            array(
                'section'         => 'about_timer_cta_section',
                'label'           => __( 'Show Upcoming Event', 'the-conference-pro' ),
                'description'     => __( 'Enable to show upcoming event timer.', 'the-conference-pro' ),
            )
        )
    );

    /** Timer */
    $wp_customize->add_setting(
        'about_timer_cta_event_time',
        array(
            'default'           => '2022-08-20', 
            'sanitize_callback' => 'the_conference_pro_sanitize_date'
        )
    );
    
     $wp_customize->add_control(
        'about_timer_cta_event_time',
        array(
            'label'           => __( 'Event Date', 'the-conference-pro' ),
            'description'     => __( 'Select upcoming event date.', 'the-conference-pro' ),
            'section'         => 'about_timer_cta_section',
            'type'            => 'date',
            'active_callback' => 'the_conference_pro_about_template_ac'
        )            
    );

    /** Banner Timer */
    $wp_customize->add_setting(
        'about_cta_event_time',
        array(
            'default'           => '00:00', 
            'sanitize_callback' => 'the_conference_pro_sanitize_time'
        )
    );
    
     $wp_customize->add_control(
        'about_cta_event_time',
        array(
            'label'           => __( 'Event Time', 'the-conference-pro' ),
            'description'     => __( 'Select upcoming event date.', 'the-conference-pro' ),
            'section'         => 'about_timer_cta_section',
            'type'            => 'time',
            'active_callback' => 'the_conference_pro_about_template_ac'
        )            
    );

    /** Note */
    $wp_customize->add_setting(
        'aboutcta_timer_note',
        array(
            'default'           => '',
            'sanitize_callback' => 'wp_kses_post' 
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Note_Control( 
			$wp_customize,
			'aboutcta_timer_note',
			array(
				'section'	  => 'about_timer_cta_section',
                'description' => sprintf( __( 'Set the time zone from %1$shere%2$s.', 'the-conference-pro' ), '<span class="text-inner-link aboutcta_timer_note">', '</span>' ),
                'active_callback' => 'the_conference_pro_about_template_ac'
			)
		)
    );

    // Readmore button label.
    $wp_customize->add_setting(
        'about_timer_cta_readmore_label',
        array(
            'default'           => __( 'BUY TICKET NOW', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field', 
            'transport'         => 'postMessage'
        )
    );
        
    $wp_customize->add_control(
        'about_timer_cta_readmore_label',
        array(
            'section'         => 'about_timer_cta_section',
            'label'           => __( 'Readmore Label', 'the-conference-pro' ),
        )
    );

    $wp_customize->selective_refresh->add_partial( 'about_timer_cta_readmore_label', array(
        'selector' => '#about_timer_cta_section .container .btn-wrap a.btn-filled',
        'render_callback' => 'the_conference_pro_get_about_timer_cta_readmore_label',
    ) );

    /** Banner link one url */
    $wp_customize->add_setting(
        'about_timer_cta_readmore_url',
        array(
            'default'           => '#',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'about_timer_cta_readmore_url',
        array(
            'section'         => 'about_timer_cta_section',
            'label'           => __( 'Readmore URL', 'the-conference-pro' ),
            'type'            => 'url',
        )
    );

    /** Background Image */
    $wp_customize->add_setting(
        'about_timer_cta_bg_image',
        array(
            'default'           => get_template_directory_uri() . '/images/counter-bg.jpg',
            'sanitize_callback' => 'the_conference_pro_sanitize_image',
        )
    );
    
    $wp_customize->add_control(
       new WP_Customize_Image_Control(
           $wp_customize,
           'about_timer_cta_bg_image',
           array(
               'label'    => __( 'Background Image', 'the-conference-pro' ),
               'section'  => 'about_timer_cta_section',
           )
       )
    );
}
add_action( 'customize_register', 'the_conference_pro_customize_register_about_template_timer_cta' );