<?php
/**
 * Appearance Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_appearance( $wp_customize ) {
    
    $wp_customize->add_panel( 
        'appearance_settings', 
        array(
            'title'       => __( 'Appearance Settings', 'the-conference-pro' ),
            'priority'    => 25,
            'capability'  => 'edit_theme_options',
            'description' => __( 'Change color and body background.', 'the-conference-pro' ),
        ) 
    );
    
    /** Move Background Image section to appearance panel */
    $wp_customize->get_section( 'colors' )->panel                          = 'appearance_settings';
    $wp_customize->get_section( 'colors' )->priority                       = 30;
    $wp_customize->get_section( 'background_image' )->panel                = 'appearance_settings';
    $wp_customize->get_section( 'background_image' )->priority             = 35;
    $wp_customize->get_section( 'background_image' )->title                = __( 'Background', 'the-conference-pro' );
    $wp_customize->get_control( 'background_image' )->active_callback      = 'the_conference_pro_body_bg_choice';       
    $wp_customize->get_control( 'background_preset' )->active_callback     = 'the_conference_pro_body_bg_choice';
    $wp_customize->get_control( 'background_position' )->active_callback   = 'the_conference_pro_body_bg_choice';
    $wp_customize->get_control( 'background_size' )->active_callback       = 'the_conference_pro_body_bg_choice';
    $wp_customize->get_control( 'background_repeat' )->active_callback     = 'the_conference_pro_body_bg_choice';
    $wp_customize->get_control( 'background_attachment' )->active_callback = 'the_conference_pro_body_bg_choice';
    $wp_customize->get_control( 'background_color' )->description          = __( 'Background color of the theme.', 'the-conference-pro' );  
    $wp_customize->get_control( 'background_color' )->priority             = 5;  
}
add_action( 'customize_register', 'the_conference_pro_customize_register_appearance' );