<?php
/**
 * Background Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_appearance_background( $wp_customize ) {
    
    /** Body Background */
    $wp_customize->add_setting( 
        'body_bg', 
        array(
            'default'           => 'image',
            'sanitize_callback' => 'the_conference_pro_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Radio_Buttonset_Control(
			$wp_customize,
			'body_bg',
			array(
				'section'	  => 'background_image',
				'label'       => __( 'Body Background', 'the-conference-pro' ),
                'description' => __( 'Choose body background as image or pattern.', 'the-conference-pro' ),
				'choices'	  => array(
					'image'   => __( 'Image', 'the-conference-pro' ),
                    'pattern' => __( 'Pattern', 'the-conference-pro' ),
				),
                'priority'    => 5
			)
		)
	);
    
    /** Background Pattern */
    $wp_customize->add_setting( 
        'bg_pattern', array(
            'default'           => 'nobg',
            'sanitize_callback' => 'the_conference_pro_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Radio_Image_Control(
			$wp_customize,
			'bg_pattern',
			array(
				'section'		  => 'background_image',
				'label'			  => __( 'Background Pattern', 'the-conference-pro' ),
				'description'	  => __( 'Choose from any of 64 awesome background patterns for your site background.', 'the-conference-pro' ),
				'choices'         => the_conference_pro_get_patterns(),
                'active_callback' => 'the_conference_pro_body_bg_choice'
			)
		)
	);
    
}
add_action( 'customize_register', 'the_conference_pro_customize_register_appearance_background' );