<?php
/**
 * Color Setting
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_color( $wp_customize ) {
    
    /** Primary Color*/
    $wp_customize->add_setting( 
        'primary_color', 
        array(
            'default'           => '#57b9a8',
            'sanitize_callback' => 'sanitize_hex_color',
        ) 
    );

    $wp_customize->add_control( 
        new WP_Customize_Color_Control( 
            $wp_customize, 
            'primary_color', 
            array(
                'label'       => __( 'Primary Color', 'the-conference-pro' ),
                'description' => __( 'Primary color of the theme.', 'the-conference-pro' ),
                'section'     => 'colors',
                'priority'    => 5,
            )
        )
    );
    
    /** Secondary Color*/
    $wp_customize->add_setting( 
        'secondary_color', 
        array(
            'default'           => '#0d2d62',
            'sanitize_callback' => 'sanitize_hex_color'
        ) 
    );

    $wp_customize->add_control( 
        new WP_Customize_Color_Control( 
            $wp_customize, 
            'secondary_color', 
            array(
                'label'       => __( 'Secondary Color', 'the-conference-pro' ),
                'description' => __( 'Secondary color of the theme.', 'the-conference-pro' ),
                'section'     => 'colors',
            )
        )
    );
    
    /** Footer Background Color*/
    $wp_customize->add_setting( 
        'footer_bg_color', 
        array(
            'default'           => '#212127',
            'sanitize_callback' => 'sanitize_hex_color'
        ) 
    );

    $wp_customize->add_control( 
        new WP_Customize_Color_Control( 
            $wp_customize, 
            'footer_bg_color', 
            array(
                'label'       => __( 'Footer Background Color', 'the-conference-pro' ),
                'description' => __( 'Footer Background color of the theme.', 'the-conference-pro' ),
                'section'     => 'colors',
            )
        )
    );
    
}
add_action( 'customize_register', 'the_conference_pro_customize_register_color' );