<?php
/**
 * Home Page Gallery Section Options
 *
 * @package rara_academic_pro
 */

function the_conference_pro_customize_register_gt_gallery( $wp_customize ) {
    /** Gallery Settings */
    $wp_customize->add_panel(
        'gt_settings',
        array(
            'title' => __( 'Gallery Page Settings', 'the-conference-pro' ),
            'priority' => 55,
        )
    );

    /** Gallery Section */
    $wp_customize->add_section(
        'gallery_template_settings',
        array(
            'title' => __( 'Gallery Section', 'the-conference-pro' ),
            'priority' => 10,
            'panel' => 'gt_settings',
        )
    );

    $wp_customize->add_setting(
        'gallery_template_note',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    );

    $wp_customize->add_control(
        new The_Conference_Pro_Note_Control(
            $wp_customize,
            'gallery_template_note',
            array(
                'section' => 'gallery_template_settings',
                'label' => __( 'Gallery Note', 'the-conference-pro'),
                'description' => __( 'Add "Text" widget for title and description, Add "Gallery" widget in Gallery Page Template.', 'the-conference-pro'),
            )
        )
    );

    $gallery_template_settings = $wp_customize->get_section( 'sidebar-widgets-gallery-template' );
    if ( ! empty( $gallery_template_settings ) ) {
        $gallery_template_settings->panel = 'gt_settings';
        $gallery_template_settings->priority = 75;
        $wp_customize->get_control( 'gallery_template_note' )->section  = 'sidebar-widgets-gallery-template';
        $wp_customize->get_control( 'gallery_template_note' )->priority  = -1;
    }
    /** Gallery Section Ends */  
}
add_action( 'customize_register', 'the_conference_pro_customize_register_gt_gallery' );