<?php
/**
 * Google Analytics Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_general_google_analytics( $wp_customize ) {
    
    /** Google Analytics Settings */
    $wp_customize->add_section(
        'google_analytics_settings',
        array(
            'title'    => __( 'Google Analytics Settings', 'the-conference-pro' ),
            'priority' => 95,
            'panel'    => 'general_settings',
        )
    );
    
    /** After Content AD Code */
    $wp_customize->add_setting(
        'google_analytics_ad_code',
        array(
            'default'           => '',
            'sanitize_callback' => 'the_conference_pro_sanitize_code'
        )
    );
        
    $wp_customize->add_control( 
        new WP_Customize_Code_Editor_Control(
            $wp_customize, 
            'google_analytics_ad_code',
            array(
                'section'     => 'google_analytics_settings',
                'label'       => __( 'Analytics Code', 'the-conference-pro' ),
                'description' => __( 'Paste your google analytics code here.', 'the-conference-pro' ),
                'code_type'   => 'javascript',             
            )
        )       
    );
    
    /** Google Analytics Settings Ends */
}
add_action( 'customize_register', 'the_conference_pro_customize_register_general_google_analytics' );

