<?php
/**
 * Header Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_general_header( $wp_customize ) {
    
    /** Header Settings */
    $wp_customize->add_section(
        'header_settings',
        array(
            'title'    => __( 'Header Settings', 'the-conference-pro' ),
            'priority' => 20,
            'panel'    => 'general_settings',
        )
    );
    
    /** Sticky Header */
    $wp_customize->add_setting(
        'ed_sticky_header',
        array(
            'default'           => false,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control( 
            $wp_customize,
            'ed_sticky_header',
            array(
                'section'       => 'header_settings',
                'label'         => __( 'Sticky Header', 'the-conference-pro' ),
                'description'   => __( 'Enable to stick header at top.', 'the-conference-pro' ),
            )
        )
    );

    /** Custom Link option */
    $wp_customize->add_setting( 
        'custom_link_option', 
        array(
            'default'           => 'custom',
            'sanitize_callback' => 'the_conference_pro_sanitize_radio',
        ) 
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Radio_Buttonset_Control(
            $wp_customize,
            'custom_link_option',
            array(
                'section'     => 'header_settings',
                'label'       => __( 'Custom Link Option', 'the-conference-pro' ),
                'description' => __( 'Choose Link as Custom or Page.', 'the-conference-pro' ),
                'choices'     => array(
                    'custom'   => __( 'Custom', 'the-conference-pro' ),
                    'page'     => __( 'Page', 'the-conference-pro' ),
                ),
            )
        )
    );

    /** Custom Link label  */
    $wp_customize->add_setting(
        'custom_link_label',
        array(
            'default'           => __( 'BUY TICKET', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'custom_link_label',
        array(
            'label'           => __( 'Custom Link Label', 'the-conference-pro' ),
            'description'     => __( 'Add cutom link button label in header.', 'the-conference-pro' ),
            'section'         => 'header_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_header_section_ac',
        )
    );

    $wp_customize->selective_refresh->add_partial( 'custom_link_label', array(
        'selector' => '.site-header .nav-btn a.btn.custom-link',
        'render_callback' => 'the_conference_pro_header_custom_link_selective_refresh',
    ) );

    /** Custom Link */
    $wp_customize->add_setting(
        'custom_link',
        array(
            'default'           => '#',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'custom_link',
        array(
            'label'           => __( 'Custom link Url', 'the-conference-pro' ),
            'description'     => __( 'Add custom link url in header.', 'the-conference-pro' ),
            'section'         => 'header_settings',
            'type'            => 'url',
            'active_callback' => 'the_conference_pro_header_section_ac',
        )
    );

    /** Page  */
    $wp_customize->add_setting(
        'custom_link_page',
        array(
            'default'           => '',
            'sanitize_callback' => 'the_conference_pro_sanitize_select',
        )
    );
    
    $wp_customize->add_control(
        'custom_link_page',
        array(
            'label'           => __( 'Select Page', 'the-conference-pro' ),
            'description'     => __( 'Page title of selected page will be used as button label.', 'the-conference-pro' ),
            'section'         => 'header_settings',
            'type'            => 'select',
            'choices'         => the_conference_pro_get_posts( 'page' ),
            'active_callback' => 'the_conference_pro_header_section_ac',
        )
    );
    
    /** Open Link in new tab */
    $wp_customize->add_setting( 
        'ed_custom_link_tab', 
        array(
            'default'           => false,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox'
        ) 
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control( 
            $wp_customize,
            'ed_custom_link_tab',
            array(
                'section'         => 'header_settings',
                'label'           => __( 'Open Link in New Tab', 'the-conference-pro' ),
                'description'     => __( 'Enable to open link in new tab.', 'the-conference-pro' ),
                'active_callback' => 'the_conference_pro_header_section_ac',
            )
        )
    );
    
    /** Header Settings Ends */
}
add_action( 'customize_register', 'the_conference_pro_customize_register_general_header' );