<?php
/**
 * Miscellaneous Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_general_misc( $wp_customize ) {
    
    /** Miscellaneous Settings */
    $wp_customize->add_section(
        'misc_settings',
        array(
            'title'    => __( 'Misc Settings', 'the-conference-pro' ),
            'priority' => 85,
            'panel'    => 'general_settings',
        )
    );
    
    /** Admin Bar */
    $wp_customize->add_setting(
        'ed_adminbar',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_adminbar',
			array(
				'section'		=> 'misc_settings',
				'label'			=> __( 'Admin Bar', 'the-conference-pro' ),
				'description'	=> __( 'Disable to hide Admin Bar in frontend when logged in.', 'the-conference-pro' ),
			)
		)
	);
    
    /** Lightbox */
    $wp_customize->add_setting(
        'ed_lightbox',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_lightbox',
			array(
				'section'		=> 'misc_settings',
				'label'			=> __( 'Lightbox', 'the-conference-pro' ),
				'description'	=> __( 'A lightbox is a stylized pop-up that allows your visitors to view larger versions of images without leaving the current page. You can enable or disable the lightbox here.', 'the-conference-pro' ),
			)
		)
	);

    /** Lightbox */
    $wp_customize->add_setting(
        'ed_animate',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control( 
            $wp_customize,
            'ed_animate',
            array(
                'section'       => 'misc_settings',
                'label'         => __( 'Animate', 'the-conference-pro' ),
                'description'   => __( 'Enable to show WOW animation effect.', 'the-conference-pro' ),
            )
        )
    );
       
    /** Last Widget Sticky */
    $wp_customize->add_setting(
        'ed_last_widget_sticky',
        array(
            'default'           => false,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_last_widget_sticky',
			array(
				'section'		=> 'misc_settings',
				'label'			=> __( 'Last Widget Sticky', 'the-conference-pro' ),
				'description'	=> __( 'Enable to stick last widget in sidebar.', 'the-conference-pro' ),
			)
		)
	);
    
    /** Drop Cap */
    $wp_customize->add_setting(
        'ed_drop_cap',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_drop_cap',
			array(
				'section'		=> 'misc_settings',
				'label'			=> __( 'Drop Cap', 'the-conference-pro' ),
				'description'	=> __( 'Enable to show first letter of word in post/page content in drop cap.', 'the-conference-pro' ),
			)
		)
	);

    /** Scroll to top */
    $wp_customize->add_setting( 'ed_scroll_to_top', array(
        'default'           => true,
        'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 
        new The_Conference_Pro_Toggle_Control( 
            $wp_customize,
            'ed_scroll_to_top', 
            array(
                'label'             => __( 'Enable Scroll to Top.', 'the-conference-pro' ),
                'section'           => 'misc_settings',
            )
        )
    );

    /** Shop Page Description */
    $wp_customize->add_setting( 
        'ed_shop_archive_description', 
        array(
            'default'           => false,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox'
        ) 
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control( 
            $wp_customize,
            'ed_shop_archive_description',
            array(
                'section'         => 'misc_settings',
                'label'           => __( 'Shop Page Description', 'the-conference-pro' ),
                'description'     => __( 'Enable to show Shop Page Description.', 'the-conference-pro' ),
                'active_callback' => 'is_woocommerce_activated'
            )
        )
    );
    
    /** $shop_archive_description */
    $wp_customize->add_setting( 
        'shop_archive_description', 
        array(
            'default'           => '',
            'sanitize_callback' => 'wp_kses_post'
        ) 
    );
    
    $wp_customize->add_control(
        'shop_archive_description',
        array(
            'section'         => 'misc_settings',
            'label'           => __( 'Description For Shop Page', 'the-conference-pro' ),
            'description'     => __( 'Write new description for Shop Page to overwrite the default description.', 'the-conference-pro' ),
            'type'            => 'textarea',
            'active_callback' => 'the_conference_pro_shop_description_ac'
        )
    );

    /** Time Zones */
    $wp_customize->add_setting(
		'timer_time_zone',
		array(
			'default'			=> 'UTC',
			'sanitize_callback' => 'the_conference_pro_sanitize_select'
		)
	);

	$wp_customize->add_control(
		new The_Conference_Pro_Select_Control(
    		$wp_customize,
    		'timer_time_zone',
    		array(
                'label'	      => __( 'Time Zones', 'the-conference-pro' ),
                'description' => __( 'Choose time zone for countdown timer in banner & timer CTA sections.', 'the-conference-pro' ),
    			'section'     => 'misc_settings',
    			'choices'     => the_conference_pro_get_timezone_identifiers(),
     		)            
		)
    );
    
    /** Note */
    $wp_customize->add_setting(
        'time_zone_note',
        array(
            'default'           => '',
            'sanitize_callback' => 'wp_kses_post' 
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Note_Control( 
			$wp_customize,
			'time_zone_note',
			array(
				'section'	  => 'misc_settings',
                'description' => sprintf( __( 'Click back to %1$sBanner Timer%2$s, %3$sCTA timer%4$s & %5$sAbout CTA Timer%6$s.', 'the-conference-pro' ), '<span class="text-inner-link time_zone_note_banner">', '</span>', '<span class="text-inner-link time_zone_note_cta">', '</span>', '<span class="text-inner-link time_zone_note_about_cta">', '</span>' ),
			)
		)
    );
        
}
add_action( 'customize_register', 'the_conference_pro_customize_register_general_misc' );