<?php
/**
 * Performance Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_general_performance( $wp_customize ) {
    
    /** Performance Settings */
    $wp_customize->add_section(
        'performance_settings',
        array(
            'title'    => __( 'Performance Settings', 'the-conference-pro' ),
            'priority' => 60,
            'panel'    => 'general_settings',
        )
    );
    
    /** Lazy Load */
    $wp_customize->add_setting(
        'ed_lazy_load',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_lazy_load',
			array(
				'section'		=> 'performance_settings',
				'label'			=> __( 'Lazy Load', 'the-conference-pro' ),
				'description'	=> __( 'Enable lazy loading of featured images.', 'the-conference-pro' ),
			)
		)
	);
    
    /** Lazy Load Content Images */
    $wp_customize->add_setting(
        'ed_lazy_load_cimage',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_lazy_load_cimage',
			array(
				'section'		=> 'performance_settings',
				'label'			=> __( 'Lazy Load Content Images', 'the-conference-pro' ),
				'description'	=> __( 'Enable lazy loading of images inside page/post content.', 'the-conference-pro' ),
			)
		)
	);
    
    /** Defer JavaScript */
    $wp_customize->add_setting(
        'ed_defer',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_defer',
			array(
				'section'		=> 'performance_settings',
				'label'			=> __( 'Defer JavaScript', 'the-conference-pro' ),
				'description'	=> __( 'Adds "defer" attribute to sript tags to improve page download speed.', 'the-conference-pro' ),
			)
		)
	);
    
    /** Sticky Header */
    $wp_customize->add_setting(
        'ed_ver',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_ver',
			array(
				'section'		=> 'performance_settings',
				'label'			=> __( 'Remove ver parameters', 'the-conference-pro' ),
				'description'	=> __( 'Enable to remove "ver" parameter from CSS and JS file calls.', 'the-conference-pro' ),
			)
		)
	);
    
    /** Locally Host Google Fonts */
    $wp_customize->add_setting(
        'ed_googlefont_local',
        array(
            'default'           => false,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_googlefont_local',
			array(
				'section'		=> 'performance_settings',
				'label'			=> __( 'Locally Host Google Fonts', 'the-conference-pro' ),
				'description'	=> sprintf( __( 'Enable to load google fonts from your own server instead from google\'s CDN. This solves privacy concerns with Google\'s CDN and their sometimes less-than-transparent policies. %1$sBack to Typgraphy%2$s', 'the-conference-pro' ), '<span class="text-inner-link ed_googlefont_local">', '</span>' )
			)
		)
    );
    
}
add_action( 'customize_register', 'the_conference_pro_customize_register_general_performance' );