<?php
/**
 * Social Sharing Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_general_sharing( $wp_customize ) {
	
    /** Social Sharing */
    $wp_customize->add_section(
        'social_sharing',
        array(
            'title'    => __( 'Social Sharing', 'the-conference-pro' ),
            'priority' => 31,
            'panel'    => 'general_settings',
        )
    );
    
    /** Enable Social Sharing Buttons */
    $wp_customize->add_setting(
        'ed_social_sharing',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_social_sharing',
			array(
				'section'     => 'social_sharing',
				'label'       => __( 'Enable Social Sharing Buttons', 'the-conference-pro' ),
                'description' => __( 'Enable or disable social sharing buttons on single posts.', 'the-conference-pro' ),
			)
		)
	);

    /** Enable Social Sharing Buttons */
    $wp_customize->add_setting(
        'ed_og_tags',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'ed_og_tags',
			array(
				'section'     => 'social_sharing',
				'label'       => __( 'Enable Open Graph Meta Tags', 'the-conference-pro' ),
                'description' => __( 'Disable this option if you\'re using Jetpack, Yoast or other plugin to maintain Open Graph meta tags.', 'the-conference-pro' ),
			)
		)
	);
    
    /** Social Sharing Buttons */
    $wp_customize->add_setting(
		'social_share', 
		array(
			'default' => array( 'facebook', 'twitter', 'pinterest', 'linkedin' ),
			'sanitize_callback' => 'the_conference_pro_sanitize_sortable',						
		)
	);

	$wp_customize->add_control(
		new The_Conference_Pro_Sortable_Control(
			$wp_customize,
			'social_share',
			array(
				'section'     => 'social_sharing',
				'label'       => __( 'Social Sharing Buttons', 'the-conference-pro' ),
				'description' => __( 'Sort or toggle social sharing buttons.', 'the-conference-pro' ),
				'choices'     => array(
            		'facebook'  => __( 'Facebook', 'the-conference-pro' ),
            		'twitter'   => __( 'Twitter', 'the-conference-pro' ),
            		'linkedin'  => __( 'Linkedin', 'the-conference-pro' ),
            		'pinterest' => __( 'Pinterest', 'the-conference-pro' ),
            		'email'     => __( 'Email', 'the-conference-pro' ),
                    'reddit'    => __( 'Reddit', 'the-conference-pro' ),
                    'tumblr'    => __( 'Tumblr', 'the-conference-pro' ),
                    'digg'      => __( 'Digg', 'the-conference-pro' ),
                    'weibo'     => __( 'Weibo', 'the-conference-pro' ),
                    'xing'      => __( 'Xing', 'the-conference-pro' ),
                    'vk'        => __( 'VK', 'the-conference-pro' ),
                    'pocket'    => __( 'GetPocket', 'the-conference-pro' ), 
                    'whatsapp'  => __( 'Whatsapp', 'the-conference-pro' ),
            		'telegram'  => __( 'Telegram', 'the-conference-pro' ),            
            	),
			)
		)
	);
    
}
add_action( 'customize_register', 'the_conference_pro_customize_register_general_sharing' );