<?php
/**
 * Banner Section
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_frontpage_banner( $wp_customize ) {
	
    $wp_customize->get_section( 'header_image' )->panel                    = 'frontpage_settings';
    $wp_customize->get_section( 'header_image' )->title                    = __( 'Banner Section', 'the-conference-pro' );
    $wp_customize->get_section( 'header_image' )->priority                 = 10;
    $wp_customize->get_control( 'header_image' )->active_callback          = 'the_conference_pro_banner_ac';
    $wp_customize->get_control( 'header_video' )->active_callback          = 'the_conference_pro_banner_ac';
    $wp_customize->get_control( 'external_header_video' )->active_callback = 'the_conference_pro_banner_ac';
    $wp_customize->get_section( 'header_image' )->description              = '';                                               
    $wp_customize->get_setting( 'header_image' )->transport                = 'refresh';
    $wp_customize->get_setting( 'header_video' )->transport                = 'refresh';
    $wp_customize->get_setting( 'external_header_video' )->transport       = 'refresh';
    
    /** Banner Options */
    $wp_customize->add_setting(
		'ed_banner_section',
		array(
			'default'			=> 'static_banner',
			'sanitize_callback' => 'the_conference_pro_sanitize_select'
		)
	);

	$wp_customize->add_control(
		new The_Conference_Pro_Select_Control(
    		$wp_customize,
    		'ed_banner_section',
    		array(
                'label'	      => __( 'Banner Options', 'the-conference-pro' ),
                'description' => __( 'Choose banner as static image/video or as a slider.', 'the-conference-pro' ),
    			'section'     => 'header_image',
    			'choices'     => array(
                    'no_banner'        => __( 'Disable Banner Section', 'the-conference-pro' ),
                    'static_banner'    => __( 'Static/Video CTA Banner', 'the-conference-pro' ),
                    'static_nl_banner' => __( 'Static/Video Newsletter Banner', 'the-conference-pro' ),
                    'slider_banner'    => __( 'Banner as Slider', 'the-conference-pro' ),
                ),
                'priority' => 5	
     		)            
		)
	);
    
    /** Title */
    $wp_customize->add_setting(
        'banner_title',
        array(
            'default'           => __( 'Lepiza Announces New Design', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'banner_title',
        array(
            'label'           => __( 'Event Title', 'the-conference-pro' ),
            'section'         => 'header_image',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_banner_ac'
        )
    );
    
    $wp_customize->selective_refresh->add_partial( 'banner_title', array(
        'selector'        => '#banner_section .container h2.banner-title',
        'render_callback' => 'the_conference_pro_get_banner_title',
    ) );
    
    /** Sub Title */
    $wp_customize->add_setting(
        'banner_subtitle',
        array(
            'default'           => __( 'October 10 & 11 - Berlin, Germany', 'the-conference-pro' ),
            'sanitize_callback' => 'wp_kses_post',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'banner_subtitle',
        array(
            'label'           => __( 'Event description', 'the-conference-pro' ),
            'section'         => 'header_image',
            'type'            => 'textarea',
            'active_callback' => 'the_conference_pro_banner_ac'
        )
    );
    
    $wp_customize->selective_refresh->add_partial( 'banner_subtitle', array(
        'selector' => '#banner_section .static-banner .container .banner-desc',
        'render_callback' => 'the_conference_pro_get_banner_sub_title',
    ) );
    
    /** Banner Label One */
    $wp_customize->add_setting(
        'banner_label_one',
        array(
            'default'           => __( 'VIEW SCHEDULE', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'banner_label_one',
        array(
            'label'           => __( 'Banner Label One', 'the-conference-pro' ),
            'section'         => 'header_image',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_banner_ac'
        )
    );
    
    $wp_customize->selective_refresh->add_partial( 'banner_label_one', array(
        'selector' => '#banner_section .static-banner .container .btn-wrap a.btn-transparent',
        'render_callback' => 'the_conference_pro_get_banner_btn_label_one',
    ) );

    /** Banner Link One */
    $wp_customize->add_setting(
        'banner_link_one',
        array(
            'default'           => '#',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'banner_link_one',
        array(
            'label'           => __( 'Banner Link One', 'the-conference-pro' ),
            'section'         => 'header_image',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_banner_ac'
        )
    );

    /** Banner Label Two */
    $wp_customize->add_setting(
        'banner_label_two',
        array(
            'default'           => __( 'BUY TICKET NOW', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'banner_label_two',
        array(
            'label'           => __( 'Banner Label Two', 'the-conference-pro' ),
            'section'         => 'header_image',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_banner_ac'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'banner_label_two', array(
        'selector' => '#banner_section .static-banner .container .btn-wrap a.btn-filled',
        'render_callback' => 'the_conference_pro_get_banner_btn_label_two',
    ) );
    
    /** Banner Link Two*/
    $wp_customize->add_setting(
        'banner_link_two',
        array(
            'default'           => '#',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'banner_link_two',
        array(
            'label'           => __( 'Banner Link Two', 'the-conference-pro' ),
            'section'         => 'header_image',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_banner_ac'
        )
    );

    /** Enable Banner Timer */
    $wp_customize->add_setting(
        'ed_banner_event_timer',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control( 
            $wp_customize,
            'ed_banner_event_timer',
            array(
                'section'         => 'header_image',
                'label'           => __( 'Show Upcoming Event', 'the-conference-pro' ),
                'description'     => __( 'Enable to show upcoming event timer.', 'the-conference-pro' ),
                'active_callback' => 'the_conference_pro_banner_ac'
            )
        )
    );

    /** Banner Timer */
    $wp_customize->add_setting(
        'banner_event_timer',
        array(
            'default'           => '2022-08-20', 
            'sanitize_callback' => 'the_conference_pro_sanitize_date'
        )
    );
    
     $wp_customize->add_control(
        'banner_event_timer',
        array(
            'label'           => __( 'Event Date', 'the-conference-pro' ),
            'description'     => __( 'Select upcoming event date.', 'the-conference-pro' ),
            'section'         => 'header_image',
            'type'            => 'date',
            'active_callback' => 'the_conference_pro_banner_ac'
        )            
    );

    /** Banner Timer */
    $wp_customize->add_setting(
        'banner_event_time',
        array(
            'default'           => '00:00', 
            'sanitize_callback' => 'the_conference_pro_sanitize_time'
        )
    );
    
     $wp_customize->add_control(
        'banner_event_time',
        array(
            'label'           => __( 'Event Time', 'the-conference-pro' ),
            'description'     => __( 'Select upcoming event date.', 'the-conference-pro' ),
            'section'         => 'header_image',
            'type'            => 'time',
            'active_callback' => 'the_conference_pro_banner_ac'
        )            
    );

    /** Note */
    $wp_customize->add_setting(
        'banner_timer_note',
        array(
            'default'           => '',
            'sanitize_callback' => 'wp_kses_post' 
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Note_Control( 
			$wp_customize,
			'banner_timer_note',
			array(
				'section'	  => 'header_image',
                'description' => sprintf( __( 'Set the time zone from %1$shere%2$s.', 'the-conference-pro' ), '<span class="text-inner-link banner_timer_note">', '</span>' ),
                'active_callback' => 'the_conference_pro_banner_ac'
			)
		)
    );

    if (is_btnw_activated()) {
        /** Banner Newsletter */
        $wp_customize->add_setting(
            'banner_newsletter',
            array(
                'default'           => '',
                'sanitize_callback' => 'wp_kses_post',
            )
        );
        
        $wp_customize->add_control(
            'banner_newsletter',
            array(
                'label'           => __( 'Banner Newsletter', 'the-conference-pro' ),
                'description'     => __( 'Enter the BlossomThemes Email Newsletter Shortcode. Ex. [BTEN id="356"]', 'the-conference-pro' ),
                'section'         => 'header_image',
                'type'            => 'text',
                'active_callback' => 'the_conference_pro_banner_ac'
            )
        );
    } else {
        $wp_customize->add_setting(
            'banner_newsletter_note',
            array(
                'sanitize_callback' => 'wp_kses_post',
            )
        );

        $wp_customize->add_control(
            new The_Conference_Pro_Plugin_Recommend_Control(
                $wp_customize,
                'banner_newsletter_note',
                array(
                    'section' => 'header_image',
                    'label' => __('Banner Newsletter', 'the-conference-pro'),
                    'capability' => 'install_plugins',
                    'plugin_slug' => 'blossomthemes-email-newsletter',
                    'description' => sprintf(__('Please install and activate the recommended plugin %1$sBlossomThemes Email Newsletter%2$s.', 'the-conference-pro'), '<strong>', '</strong>'),
                    'active_callback' => 'the_conference_pro_banner_ac',
                )
            )
        );
    }

    /** Slider Content Style */
    $wp_customize->add_setting(
		'slider_type',
		array(
			'default'			=> 'latest_posts',
			'sanitize_callback' => 'the_conference_pro_sanitize_select'
		)
	);

	$wp_customize->add_control(
		new The_Conference_Pro_Select_Control(
    		$wp_customize,
    		'slider_type',
    		array(
                'label'	  => __( 'Slider Content Style', 'the-conference-pro' ),
    			'section' => 'header_image',
    			'choices' => array(
                    'latest_posts' => __( 'Latest Posts', 'the-conference-pro' ),
                    'cat'          => __( 'Category', 'the-conference-pro' ),
                    'pages'        => __( 'Pages', 'the-conference-pro' ),
                    'custom'       => __( 'Custom', 'the-conference-pro' ),
                ),
                'active_callback' => 'the_conference_pro_banner_ac'	
     		)
		)
	);
    
    /** Slider Category */
    $wp_customize->add_setting(
		'slider_cat',
		array(
			'default'			=> '',
			'sanitize_callback' => 'the_conference_pro_sanitize_select'
		)
	);

	$wp_customize->add_control(
		new The_Conference_Pro_Select_Control(
    		$wp_customize,
    		'slider_cat',
    		array(
                'label'	          => __( 'Slider Category', 'the-conference-pro' ),
    			'section'         => 'header_image',
    			'choices'         => the_conference_pro_get_categories(),
                'active_callback' => 'the_conference_pro_banner_ac'	
     		)
		)
	);
    
    /** No. of slides */
    $wp_customize->add_setting(
        'no_of_slides',
        array(
            'default'           => 3,
            'sanitize_callback' => 'the_conference_pro_sanitize_number_absint'
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Slider_Control( 
			$wp_customize,
			'no_of_slides',
			array(
				'section'     => 'header_image',
                'label'       => __( 'Number of Slides', 'the-conference-pro' ),
                'description' => __( 'Choose the number of slides you want to display', 'the-conference-pro' ),
                'choices'	  => array(
					'min' 	=> 1,
					'max' 	=> 20,
					'step'	=> 1,
				),
                'active_callback' => 'the_conference_pro_banner_ac'                 
			)
		)
	);
    
    /** Slider Pages */
    $wp_customize->add_setting( 
        new The_Conference_Pro_Repeater_Setting( 
            $wp_customize, 
            'slider_pages', 
            array(
                'default'           => '',
                'sanitize_callback' => array( 'The_Conference_Pro_Repeater_Setting', 'sanitize_repeater_setting' ),
            ) 
        ) 
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Control_Repeater(
			$wp_customize,
			'slider_pages',
			array(
				'section' => 'header_image',				
				'label'	  => __( 'Slider Pages ', 'the-conference-pro' ),
				'fields'  => array(
                    'page' => array(
                        'type'    => 'select',
                        'label'   => __( 'Select Page for slider', 'the-conference-pro' ),
                        'choices' => the_conference_pro_get_posts( 'page', true )
                    )
                ),
                'row_label' => array(
                    'type'  => 'field',
                    'value' => __( 'pages', 'the-conference-pro' ),
                    'field' => 'page'
                ),
                'active_callback' => 'the_conference_pro_banner_ac'                        
			)
		)
	);
    
    /** Add Slides */
    $wp_customize->add_setting( 
        new The_Conference_Pro_Repeater_Setting( 
            $wp_customize, 
            'slider_custom', 
            array(
                'default'           => '',
                'sanitize_callback' => array( 'The_Conference_Pro_Repeater_Setting', 'sanitize_repeater_setting' ),                             
            ) 
        ) 
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Control_Repeater(
			$wp_customize,
			'slider_custom',
			array(
				'section' => 'header_image',				
				'label'	  => __( 'Add Sliders', 'the-conference-pro' ),
                'fields'  => array(
                    'thumbnail' => array(
                        'type'  => 'image', 
                        'label' => __( 'Add Image', 'the-conference-pro' ),                
                    ),
                    'title'     => array(
                        'type'  => 'textarea',
                        'label' => __( 'Title', 'the-conference-pro' ),
                    ),
                    'subtitle'   => array(
                        'type'  => 'text',
                        'label' => __( 'Subtitle', 'the-conference-pro' ),
                    ),
                    'link'     => array(
                        'type'  => 'text',
                        'label' => __( 'Link', 'the-conference-pro' ),
                    ),
                ),
                'row_label' => array(
                    'type'  => 'field',
                    'value' => __( 'Slide', 'the-conference-pro' ),
                    'field' => 'title'
                ),
                'active_callback' => 'the_conference_pro_banner_ac'                                              
			)
		)
	);
    
    /** HR */
    $wp_customize->add_setting(
        'hr',
        array(
            'default'           => '',
            'sanitize_callback' => 'wp_kses_post' 
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Note_Control( 
			$wp_customize,
			'hr',
			array(
				'section'	  => 'header_image',
				'description' => '<hr/>',
                'active_callback' => 'the_conference_pro_banner_ac'
			)
		)
    ); 
    
    /** Slider Auto */
    $wp_customize->add_setting(
        'slider_auto',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'slider_auto',
			array(
				'section'     => 'header_image',
				'label'       => __( 'Slider Auto', 'the-conference-pro' ),
                'description' => __( 'Enable slider auto transition.', 'the-conference-pro' ),
                'active_callback' => 'the_conference_pro_banner_ac'
			)
		)
	);
    
    /** Slider Loop */
    $wp_customize->add_setting(
        'slider_loop',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'slider_loop',
			array(
				'section'     => 'header_image',
				'label'       => __( 'Slider Loop', 'the-conference-pro' ),
                'description' => __( 'Enable slider loop.', 'the-conference-pro' ),
                'active_callback' => 'the_conference_pro_banner_ac'
			)
		)
	);
    
    /** Slider Caption */
    $wp_customize->add_setting(
        'slider_caption',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'slider_caption',
			array(
				'section'     => 'header_image',
				'label'       => __( 'Slider Caption', 'the-conference-pro' ),
                'description' => __( 'Enable slider caption.', 'the-conference-pro' ),
                'active_callback' => 'the_conference_pro_banner_ac'
			)
		)
	);
    
    /** Full Image */
    $wp_customize->add_setting(
        'slider_full_image',
        array(
            'default'           => false,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Toggle_Control( 
			$wp_customize,
			'slider_full_image',
			array(
				'section'         => 'header_image',
				'label'           => __( 'Full Image', 'the-conference-pro' ),
                'description'     => __( 'Enable to use full size image in slider.', 'the-conference-pro' ),
                'active_callback' => 'the_conference_pro_banner_ac'
			)
		)
	);
    
    /** Slider Animation */
    $wp_customize->add_setting(
		'slider_animation',
		array(
			'default'			=> '',
			'sanitize_callback' => 'the_conference_pro_sanitize_select'
		)
	);

	$wp_customize->add_control(
		new The_Conference_Pro_Select_Control(
    		$wp_customize,
    		'slider_animation',
    		array(
                'label'	      => __( 'Slider Animation', 'the-conference-pro' ),
                'section'     => 'header_image',
    			'choices'     => array(
                    'bounceOut'      => __( 'Bounce Out', 'the-conference-pro' ),
                    'bounceOutLeft'  => __( 'Bounce Out Left', 'the-conference-pro' ),
                    'bounceOutRight' => __( 'Bounce Out Right', 'the-conference-pro' ),
                    'bounceOutUp'    => __( 'Bounce Out Up', 'the-conference-pro' ),
                    'bounceOutDown'  => __( 'Bounce Out Down', 'the-conference-pro' ),
                    'fadeOut'        => __( 'Fade Out', 'the-conference-pro' ),
                    'fadeOutLeft'    => __( 'Fade Out Left', 'the-conference-pro' ),
                    'fadeOutRight'   => __( 'Fade Out Right', 'the-conference-pro' ),
                    'fadeOutUp'      => __( 'Fade Out Up', 'the-conference-pro' ),
                    'fadeOutDown'    => __( 'Fade Out Down', 'the-conference-pro' ),
                    'flipOutX'       => __( 'Flip OutX', 'the-conference-pro' ),
                    'flipOutY'       => __( 'Flip OutY', 'the-conference-pro' ),
                    'hinge'          => __( 'Hinge', 'the-conference-pro' ),
                    'pulse'          => __( 'Pulse', 'the-conference-pro' ),
                    'rollOut'        => __( 'Roll Out', 'the-conference-pro' ),
                    'rotateOut'      => __( 'Rotate Out', 'the-conference-pro' ),
                    'rubberBand'     => __( 'Rubber Band', 'the-conference-pro' ),
                    'shake'          => __( 'Shake', 'the-conference-pro' ),
                    ''               => __( 'Slide', 'the-conference-pro' ),
                    'slideOutLeft'   => __( 'Slide Out Left', 'the-conference-pro' ),
                    'slideOutRight'  => __( 'Slide Out Right', 'the-conference-pro' ),
                    'slideOutUp'     => __( 'Slide Out Up', 'the-conference-pro' ),
                    'slideOutDown'   => __( 'Slide Out Down', 'the-conference-pro' ),
                    'swing'          => __( 'Swing', 'the-conference-pro' ),
                    'tada'           => __( 'Tada', 'the-conference-pro' ),
                    'zoomOut'        => __( 'Zoom Out', 'the-conference-pro' ),
                    'zoomOutLeft'    => __( 'Zoom Out Left', 'the-conference-pro' ),
                    'zoomOutRight'   => __( 'Zoom Out Right', 'the-conference-pro' ),
                    'zoomOutUp'      => __( 'Zoom Out Up', 'the-conference-pro' ),
                    'zoomOutDown'    => __( 'Zoom Out Down', 'the-conference-pro' ),                    
                ),
                'active_callback' => 'the_conference_pro_banner_ac'                                	
     		)
		)
	);
    
    /** Readmore Text */
    $wp_customize->add_setting(
        'slider_readmore',
        array(
            'default'           => __( 'Continue Reading', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage' 
        )
    );
    
    $wp_customize->add_control(
        'slider_readmore',
        array(
            'type'            => 'text',
            'section'         => 'header_image',
            'label'           => __( 'Slider Readmore', 'the-conference-pro' ),
            'active_callback' => 'the_conference_pro_banner_ac'
        )
    );
    
    $wp_customize->selective_refresh->add_partial( 'slider_readmore', array(
        'selector' => '#banner-slider .item .banner-caption .btn-wrap a.btn-transparent',
        'render_callback' => 'the_conference_pro_get_banner_slider_readmore',
    ) );
    /** Slider Settings Ends */  
}
add_action( 'customize_register', 'the_conference_pro_customize_register_frontpage_banner' );