<?php
/**
 * FAQ Section
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_frontpage_faq( $wp_customize ){

    /** FAQ Section */
    $wp_customize->add_section(
        'faq_section',
        array(
            'title'    => __( 'FAQ Section', 'the-conference-pro' ),
            'priority' => 70,
            'panel'    => 'frontpage_settings',
        )
    );

    // view all button label.
    $wp_customize->add_setting(
        'faq_viewall_label',
        array(
            'default'           => __( 'VIEW ALL', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field', 
            'transport'         => 'postMessage'
        )
    );
        
    $wp_customize->add_control(
        'faq_viewall_label',
        array(
            'section'         => 'faq_section',
            'priority'        => 100,
            'label'           => esc_html__( 'View All Label', 'the-conference-pro' ),
            'active_callback' => 'the_conference_pro_frontpage_faq_section_ac'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'faq_viewall_label', array(
        'selector' => '#faq_section .container .btn-wrap a.btn-filled',
        'render_callback' => 'the_conference_pro_faq_section_selective_refresh',
    ) );

    $faq_section = $wp_customize->get_section( 'sidebar-widgets-faq' );

    if( ! empty( $faq_section ) ){
        $faq_section->panel = 'frontpage_settings';
        $faq_section->priority = 70;
        $wp_customize->get_control( 'faq_viewall_label' )->section  = 'sidebar-widgets-faq';
    }
}
add_action( 'customize_register', 'the_conference_pro_customize_register_frontpage_faq' );