<?php
/**
 * Home Page Gallery Section Options
 *
 * @package rara_academic_pro
 */

function the_conference_pro_customize_register_frontpage_gallery( $wp_customize ) {

    /** Gallery Section */
    $wp_customize->add_section(
        'gallery_settings',
        array(
            'title' => __( 'Gallery Section', 'the-conference-pro' ),
            'priority' => 75,
            'panel' => 'frontpage_settings',
        )
    );

    /** Button Label */
    $wp_customize->add_setting(
        'gallery_btn_label',
        array(
            'default'           =>  __( 'SEE ALL PHOTOS', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'gallery_btn_label',
        array(
            'label'    => __( 'Button Label', 'the-conference-pro' ),
            'section'  => 'gallery_settings',
            'type'     => 'text',
            'active_callback' => 'the_conference_pro_frontpage_gallery_section_ac'
        )
    );
    
    /** Selective refresh for gallery section readmore. */
    $wp_customize->selective_refresh->add_partial( 'gallery_btn_label', array(
        'selector'        => '#gallery_section .container a.btn-filled',
        'render_callback' => 'the_conference_pro_gallery_btn_label_selective_refresh',
    ) );

    $gallery_section = $wp_customize->get_section( 'sidebar-widgets-gallery' );

    if ( ! empty( $gallery_section ) ) {
        $gallery_section->panel = 'frontpage_settings';
        $gallery_section->priority = 75;
        $wp_customize->get_control( 'gallery_btn_label' )->section  = 'sidebar-widgets-gallery';
    }
    /** Gallery Section Ends */  
}
add_action( 'customize_register', 'the_conference_pro_customize_register_frontpage_gallery' );