<?php
/**
 * One Page Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_frontpage_onepage( $wp_customize ){
    
    /** Sort Front Page Section */
    $wp_customize->add_section(
        'one_page_settings',
        array(
            'title'    => __( 'One Page Settings', 'the-conference-pro' ),
            'priority' => 95,
            'panel'    => 'frontpage_settings',
        )
    );
    
    /** Blog Options */
    $wp_customize->add_setting(
        'ed_one_page',
        array(
            'default'           => false,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox'
        )
    );

    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control(
            $wp_customize,
            'ed_one_page',
            array(
                'label'       => __( 'Enable Section Menu', 'the-conference-pro' ),
                'description' => __( 'Enable to make home page one page scrolling with section menu.', 'the-conference-pro' ),
                'section'     => 'one_page_settings',
            )            
        )
    );
    
    /** Blog Options */
    $wp_customize->add_setting(
        'ed_home_link',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox'
        )
    );

    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control(
            $wp_customize,
            'ed_home_link',
            array(
                'label'           => __( 'Home Link', 'the-conference-pro' ),
                'description'     => __( 'Enable to display "Home" link in section menu.', 'the-conference-pro' ),
                'section'         => 'one_page_settings',
                'active_callback' => 'the_conference_pro_onepage_menu_ac'
            )            
        )
    );
    
    /** About Section Menu Label  */
    $wp_customize->add_setting(
        'label_about',
        array(
            'default'           => __( 'About', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_about',
        array(
            'label'           => __( 'About Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Counter Section Menu Label  */
    $wp_customize->add_setting(
        'label_stat_counter',
        array(
            'default'           => __( 'Statistics', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_stat_counter',
        array(
            'label'           => __( 'Counter Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Conference Section Menu Label  */
    $wp_customize->add_setting(
        'label_conference',
        array(
            'default'           => __( 'Conferences', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_conference',
        array(
            'label'           => __( 'Conference Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Speakers Section Menu Label  */
    $wp_customize->add_setting(
        'label_speakers',
        array(
            'default'           => __( 'Speakers', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_speakers',
        array(
            'label'           => __( 'Speakers Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Schedule Section Menu Label  */
    $wp_customize->add_setting(
        'label_schedule',
        array(
            'default'           => __( 'Schedule', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_schedule',
        array(
            'label'           => __( 'Schedule Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Ticket Section Menu Label  */
    $wp_customize->add_setting(
        'label_ticket',
        array(
            'default'           => __( 'Ticket', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_ticket',
        array(
            'label'           => __( 'Ticket Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Testimonial Section Menu Label  */
    $wp_customize->add_setting(
        'label_testimonial',
        array(
            'default'           => __( 'Testimonial', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_testimonial',
        array(
            'label'           => __( 'Testimonial Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Timer CTA Section Menu Label  */
    $wp_customize->add_setting(
        'label_timer_cta',
        array(
            'default'           => __( 'Timer CTA', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_timer_cta',
        array(
            'label'           => __( 'Timer CTA Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Sponsor Section Menu Label  */
    $wp_customize->add_setting(
        'label_sponsor',
        array(
            'default'           => __( 'Sponsor', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_sponsor',
        array(
            'label'           => __( 'Sponsor Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );
    
    /** CTA Section Menu Label  */
    $wp_customize->add_setting(
        'label_cta',
        array(
            'default'           => __( 'Call to Action', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_cta',
        array(
            'label'           => __( 'CTA Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** FAQ Section Menu Label  */
    $wp_customize->add_setting(
        'label_faq',
        array(
            'default'           => __( 'FAQ\'S', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_faq',
        array(
            'label'           => __( 'FAQ Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Gallery Section Menu Label  */
    $wp_customize->add_setting(
        'label_gallery',
        array(
            'default'           => __( 'Gallery', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_gallery',
        array(
            'label'           => __( 'Gallery Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Blog Section Menu Label  */
    $wp_customize->add_setting(
        'label_blog',
        array(
            'default'           => __( 'Blog', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_blog',
        array(
            'label'           => __( 'Blog Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );

    /** Contact Section Menu Label  */
    $wp_customize->add_setting(
        'label_contact',
        array(
            'default'           => __( 'Contact', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'label_contact',
        array(
            'label'           => __( 'Contact Section Menu Label', 'the-conference-pro' ),
            'description'     => __( 'Left blank to hide the section in the menu.', 'the-conference-pro' ),
            'section'         => 'one_page_settings',
            'type'            => 'text',
            'active_callback' => 'the_conference_pro_onepage_menu_ac'
        )
    );
}
add_action( 'customize_register', 'the_conference_pro_customize_register_frontpage_onepage' );