<?php
/**
 * Schedule Section
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_frontpage_schedule( $wp_customize ){

    /** Schedule Section */
    $wp_customize->add_section(
        'schedule_section',
        array(
            'title'    => __( 'Schedule Section', 'the-conference-pro' ),
            'priority' => 40,
            'panel'    => 'frontpage_settings',
        )
    );

    /** Schedule title */
    $wp_customize->add_setting(
        'schedule_section_title',
        array(
            'default'           => __( 'Schedule', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'schedule_section_title',
        array(
            'section' => 'schedule_section',
            'label'   => __( 'Schedule Title', 'the-conference-pro' ),
            'type'    => 'text',
        )
    );

    /** Selective refresh for schedule title. */
    $wp_customize->selective_refresh->add_partial( 'schedule_section_title', array(
        'selector'            => '#schedule_section .schedule-content-holder .container h2.section-title',
        'render_callback'     => 'the_conference_pro_schedule_section_title_selective_refresh',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
    ) );

    /** Schedule description */
    $wp_customize->add_setting(
        'schedule_section_subtitle',
        array(
            'default'           => __( 'Highly configurable block with optional auditoriums and threads', 'the-conference-pro' ),
            'sanitize_callback' => 'wp_kses_post',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'schedule_section_subtitle',
        array(
            'section' => 'schedule_section',
            'label'   => __( 'Schedule Description', 'the-conference-pro' ),
            'type'    => 'textarea',
        )
    ); 

    /** Selective refresh for blog description. */
    $wp_customize->selective_refresh->add_partial( 'schedule_section_subtitle', array(
        'selector'            => '#schedule_section .schedule-content-holder .container .section-desc',
        'render_callback'     => 'the_conference_pro_schedule_section_subtitle_selective_refresh',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
    ) );

    /** Readmore Text */
    $wp_customize->add_setting(
        'schedule_section_readmore',
        array(
            'default'           => __( 'VIEW DETAILS', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage' 
        )
    );
    
    $wp_customize->add_control(
        'schedule_section_readmore',
        array(
            'type'            => 'text',
            'section'         => 'schedule_section',
            'label'           => __( 'Schedule Readmore', 'the-conference-pro' ),
            'active_callback' => 'the_conference_pro_frontpage_schedule_section_ac'
        )
    );

    /** Selective refresh for blog description. */
    $wp_customize->selective_refresh->add_partial( 'schedule_section_readmore', array(
        'selector'            => '#schedule_section .schedule-content-holder .container a.btn-filled',
        'render_callback'     => 'the_conference_pro_schedule_section_readmore_selective_refresh',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
    ) );

    /** 24 hours time format */
    $wp_customize->add_setting( 
        'ed_schedule_24hrs_time', 
        array(
            'default'           => false,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox'
        ) 
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control( 
            $wp_customize,
            'ed_schedule_24hrs_time',
            array(
                'section'     => 'schedule_section',
                'label'       => __( 'Time Format', 'the-conference-pro' ),
                'description' => __( 'Enable to set 24 hours time format.', 'the-conference-pro' ),
            )
        )
    );
}
add_action( 'customize_register', 'the_conference_pro_customize_register_frontpage_schedule' );