<?php
/**
 * Sort front Page Settings
 *
 * @package The_Conference_Pro
 */
if ( ! function_exists( 'the_conference_pro_customize_register_frontpage_sort' ) ) :

function the_conference_pro_customize_register_frontpage_sort( $wp_customize ){
    
    /** Sort Front Page Section */
    $wp_customize->add_section(
        'sort_front_page_settings',
        array(
            'title'    => __( 'Sort Front Page Section', 'the-conference-pro' ),
            'priority' => 100,
            'panel'    => 'frontpage_settings',
        )
    );
    
    /** Sort Front Page Section Section */
    $wp_customize->add_setting(
		'front_sort', 
		array(
			'default' => array( 'about', 'stat-counter', 'recent-conference', 'speakers', 'schedule', 'ticket', 'testimonial', 'timer-cta', 'sponsor', 'cta', 'faq', 'gallery', 'blog', 'contact', 'map' ),
			'sanitize_callback' => 'the_conference_pro_sanitize_sortable',						
		)
	);

	$wp_customize->add_control(
		new The_Conference_Pro_Sortable_Control(
			$wp_customize,
			'front_sort',
			array(
				'section'     => 'sort_front_page_settings',
				'label'       => __( 'Sort Sections', 'the-conference-pro' ),
				'description' => __( 'Sort or toggle front page sections.', 'the-conference-pro' ),
				'choices'     => array(
					'about'             => __( 'About Section', 'the-conference-pro' ),
					'stat-counter'      => __( 'Stat Counter Section', 'the-conference-pro' ),
					'recent-conference' => __( 'Recent Conferences Section', 'the-conference-pro' ),
					'speakers'          => __( 'Speakers Section', 'the-conference-pro' ),
					'schedule'          => __( 'Schedule Section', 'the-conference-pro' ),
					'ticket'            => __( 'Ticket Section', 'the-conference-pro' ),
					'testimonial'       => __( 'Testimonial Section', 'the-conference-pro' ),
					'timer-cta'         => __( 'Timer CTA Section', 'the-conference-pro' ),
					'sponsor'           => __( 'Sponsor Section', 'the-conference-pro' ),
					'cta'               => __( 'Call To Action Section', 'the-conference-pro' ),
					'faq'               => __( 'FAQ Section', 'the-conference-pro' ),
					'gallery'           => __( 'Gallery Section', 'the-conference-pro' ),
					'blog'              => __( 'Blog Section', 'the-conference-pro' ),
					'contact'           => __( 'Contact Section', 'the-conference-pro' ),
					'map'               => __( 'Google Map Section', 'the-conference-pro' ),
            	),
			)
		)
	);
    
}
add_action( 'customize_register', 'the_conference_pro_customize_register_frontpage_sort' );
endif;