<?php
/**
 * Testomonial Section
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_frontpage_testimonial( $wp_customize ){

    /** Testomonial Section */
    $wp_customize->add_section(
        'testimonial_section',
        array(
            'title'    => __( 'Testomonial Section', 'the-conference-pro' ),
            'priority' => 50,
            'panel'    => 'frontpage_settings',
        )
    );

    // view all button label.
    $wp_customize->add_setting(
        'testimonial_viewall_label',
        array(
            'default'           => __( 'SEE ALL TESTIMONIALS', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field', 
            'transport'         => 'postMessage'
        )
    );
        
    $wp_customize->add_control(
        'testimonial_viewall_label',
        array(
            'section'         => 'testimonial_section',
            'priority'        => 100,
            'label'           => esc_html__( 'View All Label', 'the-conference-pro' ),
            'active_callback' => 'the_conference_pro_frontpage_testimonial_section_ac'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'testimonial_viewall_label', array(
        'selector' => '#testimonial_section .container .btn-wrap a.btn-filled',
        'render_callback' => 'the_conference_pro_get_testimonial_viewall_label',
    ) );

    $testimonial_section = $wp_customize->get_section( 'sidebar-widgets-testimonial' );

    if ( ! empty( $testimonial_section ) ) {
        $testimonial_section->panel = 'frontpage_settings';
        $testimonial_section->priority = 50;
        $wp_customize->get_control( 'testimonial_viewall_label' )->section  = 'sidebar-widgets-testimonial';
    }
}
add_action( 'customize_register', 'the_conference_pro_customize_register_frontpage_testimonial' );