<?php
/**
 * Ticket Section
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_frontpage_ticket_section( $wp_customize ){

    /** Ticket Section */
    $wp_customize->add_section(
        'ticket_section',
        array(
            'title'    => __( 'Ticket Section', 'the-conference-pro' ),
            'priority' => 45,
            'panel'    => 'frontpage_settings',
        )
    );

   /** Background Image */
    $wp_customize->add_setting(
        'ticket_bg_image',
        array(
            'default'           => get_template_directory_uri() . '/images/counter-bg.jpg',
            'sanitize_callback' => 'the_conference_pro_sanitize_image',
        )
    );
    
    $wp_customize->add_control(
       new WP_Customize_Image_Control(
           $wp_customize,
           'ticket_bg_image',
           array(
               'label'    => __( 'Background Image', 'the-conference-pro' ),
               'section'  => 'ticket_section',
               'priority' => -1
           )
       )
    );

    // view all button label.
    $wp_customize->add_setting(
        'ticket_viewall_label',
        array(
            'default'           => __( 'VIEW TICKETS', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field', 
            'transport'         => 'postMessage'
        )
    );
        
    $wp_customize->add_control(
        'ticket_viewall_label',
        array(
            'section'         => 'ticket_section',
            'priority'        => 100,
            'label'           => esc_html__( 'View All Label', 'the-conference-pro' ),
            'active_callback' => 'the_conference_pro_frontpage_ticket_section_ac'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'ticket_viewall_label', array(
        'selector' => '#ticket_section .container .btn-wrap a.btn-filled',
        'render_callback' => 'the_conference_pro_ticket_section_viewall_label_selective_refresh',
    ) );

    $ticket_section = $wp_customize->get_section( 'sidebar-widgets-ticket' );

    if ( ! empty( $ticket_section ) ) {
        $ticket_section->panel = 'frontpage_settings';
        $ticket_section->priority = 45;
        $wp_customize->get_control( 'ticket_bg_image' )->section  = 'sidebar-widgets-ticket';
        $wp_customize->get_control( 'ticket_viewall_label' )->section  = 'sidebar-widgets-ticket';
    }
}
add_action( 'customize_register', 'the_conference_pro_customize_register_frontpage_ticket_section' );