<?php
/**
 * Timer CTA Section
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_frontpage_timer_cta( $wp_customize ){

    /** Timer CTA Section */
    $wp_customize->add_section(
        'timer_cta_section',
        array(
            'title'    => __( 'Timer CTA Section', 'the-conference-pro' ),
            'priority' => 55,
            'panel'    => 'frontpage_settings',
        )
    );

    /** Blog title */
    $wp_customize->add_setting(
        'timer_cta_title',
        array(
            'default'           => __( 'Hurry Up For Early Bird Tickets!', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'timer_cta_title',
        array(
            'section'         => 'timer_cta_section',
            'label'           => __( 'Title', 'the-conference-pro' ),
        )
    );

    /** Selective refresh for timer cta title. */
    $wp_customize->selective_refresh->add_partial( 'timer_cta_title', array(
        'selector'            => '#timer-cta_section .container h2.section-title',
        'render_callback'     => 'the_conference_pro_timer_cta_title_selective_refresh',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
    ) );

    /** Blog description */
    $wp_customize->add_setting(
        'timer_cta_description',
        array(
            'default'           => __( 'See what other poeple are saying about us', 'the-conference-pro' ),
            'sanitize_callback' => 'wp_kses_post',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'timer_cta_description',
        array(
            'section'         => 'timer_cta_section',
            'label'           => __( 'Description', 'the-conference-pro' ),
            'type'            => 'textarea',
        )
    ); 

    /** Selective refresh for timer cta description. */
    $wp_customize->selective_refresh->add_partial( 'timer_cta_description', array(
        'selector'            => '#timer-cta_section .container .section-desc',
        'render_callback'     => 'the_conference_pro_timer_cta_description_selective_refresh',
        'container_inclusive' => false,
        'fallback_refresh'    => true,
    ) );

    /** Enable Banner Timer */
    $wp_customize->add_setting(
        'ed_timer_cta_event_time',
        array(
            'default'           => true,
            'sanitize_callback' => 'the_conference_pro_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Toggle_Control( 
            $wp_customize,
            'ed_timer_cta_event_time',
            array(
                'section'         => 'timer_cta_section',
                'label'           => __( 'Show Upcoming Event', 'the-conference-pro' ),
                'description'     => __( 'Enable to show upcoming event timer.', 'the-conference-pro' ),
            )
        )
    );

    /** Timer */
    $wp_customize->add_setting(
        'timer_cta_event_time',
        array(
            'default'           => '2022-08-20', 
            'sanitize_callback' => 'the_conference_pro_sanitize_date'
        )
    );
    
     $wp_customize->add_control(
        'timer_cta_event_time',
        array(
            'label'           => __( 'Event Date', 'the-conference-pro' ),
            'description'     => __( 'Select upcoming event date.', 'the-conference-pro' ),
            'section'         => 'timer_cta_section',
            'type'            => 'date',
            'active_callback' => 'the_conference_pro_timer_cta_ac'
        )            
    );

    /** Banner Timer */
    $wp_customize->add_setting(
        'cta_event_time',
        array(
            'default'           => '00:00', 
            'sanitize_callback' => 'the_conference_pro_sanitize_time'
        )
    );
    
     $wp_customize->add_control(
        'cta_event_time',
        array(
            'label'           => __( 'Event Time', 'the-conference-pro' ),
            'description'     => __( 'Select upcoming event date.', 'the-conference-pro' ),
            'section'         => 'timer_cta_section',
            'type'            => 'time',
            'active_callback' => 'the_conference_pro_timer_cta_ac'
        )            
    );

    /** Note */
    $wp_customize->add_setting(
        'cta_timer_note',
        array(
            'default'           => '',
            'sanitize_callback' => 'wp_kses_post' 
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Note_Control( 
			$wp_customize,
			'cta_timer_note',
			array(
				'section'	  => 'timer_cta_section',
                'description' => sprintf( __( 'Set the time zone from %1$shere%2$s.', 'the-conference-pro' ), '<span class="text-inner-link cta_timer_note">', '</span>' ),
                'active_callback' => 'the_conference_pro_timer_cta_ac'
			)
		)
    );

    // Readmore button label.
    $wp_customize->add_setting(
        'timer_cta_readmore_label',
        array(
            'default'           => __( 'BUY TICKET NOW', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field', 
            'transport'         => 'postMessage'
        )
    );
        
    $wp_customize->add_control(
        'timer_cta_readmore_label',
        array(
            'section'         => 'timer_cta_section',
            'label'           => __( 'Readmore Label', 'the-conference-pro' ),
        )
    );

    /** Selective refresh for timer cta readmore. */
    $wp_customize->selective_refresh->add_partial( 'timer_cta_readmore_label', array(
        'selector' => '#timer-cta_section .container .btn-wrap a.btn-filled',
        'render_callback' => 'the_conference_pro_timer_cta_readmore_selective_refresh',
    ) );

    /** Banner link one url */
    $wp_customize->add_setting(
        'timer_cta_readmore_url',
        array(
            'default'           => '#',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'timer_cta_readmore_url',
        array(
            'section'         => 'timer_cta_section',
            'label'           => __( 'Readmore URL', 'the-conference-pro' ),
            'type'            => 'url',
        )
    );

    /** Background Image */
    $wp_customize->add_setting(
        'timer_cta_bg_image',
        array(
            'default'           => get_template_directory_uri() . '/images/counter-bg.jpg',
            'sanitize_callback' => 'the_conference_pro_sanitize_image',
        )
    );
    
    $wp_customize->add_control(
       new WP_Customize_Image_Control(
           $wp_customize,
           'timer_cta_bg_image',
           array(
               'label'    => __( 'Background Image', 'the-conference-pro' ),
               'section'  => 'timer_cta_section',
           )
       )
    );
}
add_action( 'customize_register', 'the_conference_pro_customize_register_frontpage_timer_cta' );