<?php
/**
 * Schedule Page Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_schedule_template( $wp_customize ) {
    
    $wp_customize->add_panel( 
        'schedule_page_setting', 
        array(
            'title'       => __( 'Schedule Page Settings', 'the-conference-pro' ),
            'priority'    => 50,
            'capability'  => 'edit_theme_options',
        ) 
    );
    
    /** Contact Page Settings */
    $wp_customize->add_section( 
        'schedule_template_settings',
         array(        
            'title'    => __( 'Title and Description Settings', 'the-conference-pro' ),
            'panel'    => 'schedule_page_setting',
            'priority' => 10,            
        ) 
    );
    
    /** Title  */
    $wp_customize->add_setting(
        'st_section_title',
        array(
            'default'           => __( 'Event Programme', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'st_section_title',
        array(
            'label'       => __( 'Title', 'the-conference-pro' ),
            'section'     => 'schedule_template_settings',
        )
    );

    $wp_customize->selective_refresh->add_partial( 'st_section_title', array(
        'selector' => '.page-template-schedule .container .site-main h1.section-title',
        'render_callback' => 'the_conference_pro_schedule_template_section_title',
    ) );

    /** Description  */
    $wp_customize->add_setting(
        'st_section_description',
        array(
            'default'           => __( 'Don\'t Miss a Thing', 'the-conference-pro' ),
            'sanitize_callback' => 'wp_kses_post',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'st_section_description',
        array(
            'label'       => __( 'Description', 'the-conference-pro' ),
            'section'     => 'schedule_template_settings',
            'type' 		  => 'textarea'
        )
    );

    $wp_customize->selective_refresh->add_partial( 'st_section_description', array(
        'selector' => '.page-template-schedule .container .site-main .section-desc',
        'render_callback' => 'the_conference_pro_schedule_template_section_description',
    ) );

    /** Banner Label One */
    $wp_customize->add_setting(
        'st_ticket_readmore',
        array(
            'default'           => __( 'BUY TICKET NOW', 'the-conference-pro' ),
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'st_ticket_readmore',
        array(
            'label'           => __( 'Ticket Button Label', 'the-conference-pro' ),
            'section'         => 'schedule_template_settings',
            'type'            => 'text',
        )
    );

    $wp_customize->selective_refresh->add_partial( 'st_ticket_readmore', array(
        'selector' => '.page-template-schedule .container .site-main .btn-wrap a.btn-filled',
        'render_callback' => 'the_conference_pro_schedule_template_ticket_readmore',
    ) );
    
    /** Banner Link One */
    $wp_customize->add_setting(
        'st_ticket_url',
        array(
            'default'           => '#',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'st_ticket_url',
        array(
            'label'           => __( 'Ticket Button URL', 'the-conference-pro' ),
            'section'         => 'schedule_template_settings',
            'type'            => 'text',
        )
    );
}
add_action( 'customize_register', 'the_conference_pro_customize_register_schedule_template' );