<?php
/**
 * Typography Body Settings
 *
 * @package The_Conference_Pro
 */

function the_conference_pro_customize_register_typography_body( $wp_customize ) {
    
    /** Body Settings */
    $wp_customize->add_section(
        'body_settings',
        array(
            'title'    => __( 'Body Settings', 'the-conference-pro' ),
            'priority' => 10,
            'panel'    => 'typography_settings'
        )
    );
    
    /** Primary Font */
    $wp_customize->add_setting(
		'primary_font',
		array(
			'default'			=> 'Nunito Sans',
			'sanitize_callback' => 'the_conference_pro_sanitize_select'
		)
	);

	$wp_customize->add_control(
		new The_Conference_Pro_Select_Control(
    		$wp_customize,
    		'primary_font',
    		array(
                'label'	      => __( 'Primary Font', 'the-conference-pro' ),
                'description' => __( 'Primary font of the site.', 'the-conference-pro' ),
    			'section'     => 'body_settings',
    			'choices'     => the_conference_pro_get_all_fonts(),	
     		)
		)
	);
        
    /** Font Size*/
    $wp_customize->add_setting( 
        'font_size', 
        array(
            'default'           => 18,
            'sanitize_callback' => 'the_conference_pro_sanitize_number_absint'
        ) 
    );
    
    $wp_customize->add_control(
		new The_Conference_Pro_Slider_Control( 
			$wp_customize,
			'font_size',
			array(
				'section'	  => 'body_settings',
				'label'		  => __( 'Font Size', 'the-conference-pro' ),
				'description' => __( 'Change the font size of your site.', 'the-conference-pro' ),
                'choices'	  => array(
					'min' 	=> 10,
					'max' 	=> 50,
					'step'	=> 1,
				)                 
			)
		)
	);

	/** Note */
    $wp_customize->add_setting(
        'typography_text',
        array(
            'default'           => '',
            'sanitize_callback' => 'wp_kses_post' 
        )
    );
    
    $wp_customize->add_control(
        new The_Conference_Pro_Note_Control( 
			$wp_customize,
			'typography_text',
			array(
				'section'	  => 'body_settings',
                'description' => sprintf( __( 'To load google fonts from your own server instead from google\'s CDN enable the %1$sLocally Host Google Fonts%2$s option in Performance Settings.', 'the-conference-pro' ), '<span class="text-inner-link typography_text">', '</span>' ),
			)
		)
    );
}
add_action( 'customize_register', 'the_conference_pro_customize_register_typography_body' );