<?php
/**
 * The Conference Pro Theme Info
 *
 * @package the_conference_pro
 */

if ( ! function_exists( 'the_conference_pro_customizer_theme_info' ) ) :
	/**
     * Add theme info
     */
	function the_conference_pro_customizer_theme_info( $wp_customize ) {
		
	    $wp_customize->add_section( 'theme_info_section', array(
			'title'       => __( 'Video Tutorials & Documentation' , 'the-conference-pro' ),
			'priority'    => 6,
		) );
	    
	    /** Important Links */
		$wp_customize->add_setting( 'theme_info_setting',
	        array(
	            'default' => '',
	            'sanitize_callback' => 'wp_kses_post',
	        )
	    );
	    
	    $theme_info = '<p>';

	    /* translators: 1: string, 2: documentation url, 3: string */
	    $theme_info .= sprintf( '%1$s<a href="%2$s" target="_blank">%3$s</a>', esc_html__( 'Video Tutorials : ', 'the-conference-pro' ), esc_url( 'https://www.youtube.com/watch?v=mZ4PfeUC_as&list=PL8D5hAypnzVhaWkBpVhvkdAdjmjHyTWGA' ), esc_html__( 'Click here.', 'the-conference-pro' ) );

	    $theme_info .= '</p><p>';

	    /* translators: 1: string, 2: documentation url, 3: string */
	    $theme_info .= sprintf( '%1$s<a href="%2$s" target="_blank">%3$s</a>', esc_html__( 'Documentation Link : ', 'the-conference-pro' ), esc_url( 'https://docs.rarathemes.com/docs/the-conference-pro/' ), esc_html__( 'Click here.', 'the-conference-pro' ) );

	    $theme_info .= '</p>';

		$wp_customize->add_control( new the_conference_pro_Note_Control( $wp_customize,
	        'theme_info_setting', 
	            array(
	                'section'     => 'theme_info_section',
	                'description' => $theme_info
	            )
	        )
	    );
	    
	}
endif;
add_action( 'customize_register', 'the_conference_pro_customizer_theme_info' );