<?php
/**
 * Help Panel.
 *
 * @package The_Conference_Pro
 */
?>
<!-- Help file panel -->
<div id="help-panel" class="panel-left">
    <div class="panel-aside">
        <h4><?php esc_html_e( 'View Our Documentation Link', 'the-conference-pro' ); ?></h4>
        <p><?php esc_html_e( 'Are you new to WordPress? Our extensive documentation has step by step guide to create an attractive website.', 'the-conference-pro' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( 'https://docs.rarathemes.com/docs/the-conference-pro/' ); ?>" title="<?php esc_attr_e( 'Visit the Documentation', 'the-conference-pro' ); ?>" target="_blank">
            <?php esc_html_e( 'View Documentation', 'the-conference-pro' ); ?>
        </a>
    </div><!-- .panel-aside -->
    
    <div class="panel-aside">
        <h4><?php esc_html_e( 'Support Ticket', 'the-conference-pro' ); ?></h4>
        <p><?php printf( __( 'It\'s always a good idea to visit our %1$sKnowledge Base%2$s before you send us a support ticket.', 'the-conference-pro' ), '<a href="'. esc_url( 'https://docs.rarathemes.com/docs/the-conference-pro/' ) .'" target="_blank">', '</a>' ); ?></p>
        <p><?php printf( __( 'If the Knowledge Base didn\'t answer your queries, submit us a %1$sSupport Ticket%2$s here. Our response time usually is less than a business day, except on the weekends.', 'the-conference-pro' ), '<a href="'. esc_url( 'https://rarathemes.com/support-ticket/' ) .'" target="_blank">', '</a>' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( 'https://rarathemes.com/support-ticket/' ); ?>" title="<?php esc_attr_e( 'Visit the Support', 'the-conference-pro' ); ?>" target="_blank">
            <?php esc_html_e( 'Contact Support', 'the-conference-pro' ); ?>
        </a>
    </div><!-- .panel-aside -->

    <div class="panel-aside">
        <h4><?php esc_html_e( 'View Our The Conference Pro Demo', 'the-conference-pro' ); ?></h4>
        <p><?php esc_html_e( 'Visit the demo of our theme to get more ideas about the design and layout of our theme.', 'the-conference-pro' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( 'https://rarathemes.com/previews/?theme=the-conference-pro' ); ?>" title="<?php esc_attr_e( 'Visit the Demo', 'the-conference-pro' ); ?>" target="_blank">
            <?php esc_html_e( 'View Demo', 'the-conference-pro' ); ?>
        </a>
    </div><!-- .panel-aside -->
</div>