<?php
/**
 * The Conference Pro Customizer Partials
 *
 * @package The_Conference_Pro
 */

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function the_conference_pro_customize_partial_blogname() {
	$blog_name = get_bloginfo( 'name' );

    if ( $blog_name ){
        return esc_html( $blog_name );
    } else {
        return false;
    }
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function the_conference_pro_customize_partial_blogdescription() {
	$blog_description = get_bloginfo( 'description' );

    if ( $blog_description ){
        return esc_html( $blog_description );
    } else {
        return false;
    }
}

if( ! function_exists( 'the_conference_pro_header_custom_link_selective_refresh' ) ) :
/**
 * Header custom link 
*/
function the_conference_pro_header_custom_link_selective_refresh(){
    $custom_link_label = get_theme_mod( 'custom_link_label', __( 'BUY TICKET', 'the-conference-pro' ) );

    if ( $custom_link_label ){
        return esc_html( $custom_link_label );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_get_banner_title' ) ) :
/**
 * Banner Title
*/
function the_conference_pro_get_banner_title(){
    $banner_title = get_theme_mod( 'banner_title', __( 'Lepiza Announces New Design', 'the-conference-pro' ) );

    if ( $banner_title ){
        return esc_html( $banner_title );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_get_banner_sub_title' ) ) :
/**
 * Banner Sub Title
*/
function the_conference_pro_get_banner_sub_title(){
    $banner_subtitle = get_theme_mod( 'banner_subtitle', __( 'October 10 & 11 - Berlin, Germany', 'the-conference-pro' ) );

    if ( $banner_subtitle ){
        return wpautop( wp_kses_post( $banner_subtitle ) );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_get_banner_btn_label_one' ) ) :
/**
 * Banner Button one label
*/
function the_conference_pro_get_banner_btn_label_one(){
    $banner_label_one = get_theme_mod( 'banner_label_one', __( 'VIEW SCHEDULE', 'the-conference-pro' ) );

    if ( $banner_label_one ){
        return esc_html( $banner_label_one );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_get_banner_btn_label_two' ) ) :
/**
 * Banner Button two label
*/
function the_conference_pro_get_banner_btn_label_two(){
    $banner_label_two = get_theme_mod( 'banner_label_two', __( 'BUY TICKET NOW', 'the-conference-pro' ) );

    if ( $banner_label_two ){
        return esc_html( $banner_label_two );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_get_banner_slider_readmore' ) ) :
/**
 * Slider Readmore
*/
function the_conference_pro_get_banner_slider_readmore(){
    $slider_readmore = get_theme_mod( 'slider_readmore', __( 'Continue Reading', 'the-conference-pro' ) );

    if ( $slider_readmore ){
        return esc_html( $slider_readmore );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_schedule_section_title_selective_refresh' ) ) :
/**
 * Schedule section title
*/
function the_conference_pro_schedule_section_title_selective_refresh(){
    $schedule_section_title = get_theme_mod( 'schedule_section_title', __( 'Schedule', 'the-conference-pro' ) );

    if ( $schedule_section_title ){
        return esc_html( $schedule_section_title );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_schedule_section_subtitle_selective_refresh' ) ) :
/**
 * Schedule section sub title
*/
function the_conference_pro_schedule_section_subtitle_selective_refresh(){
    $schedule_section_subtitle =  get_theme_mod( 'schedule_section_subtitle', __( 'Highly configurable block with optional auditoriums and threads', 'the-conference-pro' ) );

    if ( $schedule_section_subtitle ){
        return wpautop( wp_kses_post( $schedule_section_subtitle ) );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_schedule_section_readmore_selective_refresh' ) ) :
/**
 * Schedule section readmore
*/
function the_conference_pro_schedule_section_readmore_selective_refresh(){
    $schedule_section_readmore = get_theme_mod( 'schedule_section_readmore', __( 'VIEW DETAILS', 'the-conference-pro' ) );

    if ( $schedule_section_readmore ){
        return esc_html( $schedule_section_readmore );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_ticket_section_viewall_label_selective_refresh' ) ) :
/**
 * Ticket section viewall
*/
function the_conference_pro_ticket_section_viewall_label_selective_refresh(){
    $ticket_viewall_label = get_theme_mod( 'ticket_viewall_label', __( 'VIEW TICKETS', 'the-conference-pro' ) );

    if ( $ticket_viewall_label ){
        return esc_html( $ticket_viewall_label );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_get_testimonial_viewall_label' ) ) :
/**
 * Testimonial section readmore
*/
function the_conference_pro_get_testimonial_viewall_label(){
    $testimonial_viewall_label = get_theme_mod( 'testimonial_viewall_label', __( 'SEE ALL TESTIMONIALS', 'the-conference-pro' ) );

    if ( $testimonial_viewall_label ){
        return esc_html( $testimonial_viewall_label );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_timer_cta_title_selective_refresh' ) ) :
/**
 * Timer timer cta section title
*/
function the_conference_pro_timer_cta_title_selective_refresh(){
    $timer_cta_title = get_theme_mod( 'timer_cta_title', __( 'Hurry Up For Early Bird Tickets!', 'the-conference-pro' ) );

    if ( $timer_cta_title ){
        return esc_html( $timer_cta_title );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_timer_cta_description_selective_refresh' ) ) :
/**
 * Timer timer cta section description
*/
function the_conference_pro_timer_cta_description_selective_refresh(){
    $timer_cta_description = get_theme_mod( 'timer_cta_description', __( 'See what other poeple are saying about us', 'the-conference-pro' ) );

    if ( $timer_cta_description ){
        return wpautop( wp_kses_post( $timer_cta_description ) );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_timer_cta_readmore_selective_refresh' ) ) :
/**
 * Timer timer cta section readmore
*/
function the_conference_pro_timer_cta_readmore_selective_refresh(){
    $timer_cta_readmore_label = get_theme_mod( 'timer_cta_readmore_label',  __( 'BUY TICKET NOW', 'the-conference-pro' ) );

    if ( $timer_cta_readmore_label ){
        return esc_html( $timer_cta_readmore_label );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_gallery_title_selective_refresh' ) ) :
/**
 * Gallery section title
*/
function the_conference_pro_gallery_title_selective_refresh(){
    $gallery_section_title = get_theme_mod( 'gallery_section_title',  __( 'Events Gallery', 'the-conference-pro' ) );

    if ( $gallery_section_title ){
        return esc_html( $gallery_section_title );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_gallery_description_selective_refresh' ) ) :
/**
 * Gallery section description
*/
function the_conference_pro_gallery_description_selective_refresh(){
    $gallery_section_description = get_theme_mod( 'gallery_section_description',  __( 'explore our past events and enjoy!', 'the-conference-pro' ) );

    if ( $gallery_section_description ){
        return wpautop( wp_kses_post( $gallery_section_description ) );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_gallery_btn_label_selective_refresh' ) ) :
/**
 * Gallery section readmore btn
*/
function the_conference_pro_gallery_btn_label_selective_refresh(){
    $gallery_btn_label = get_theme_mod( 'gallery_btn_label',  __( 'SEE ALL PHOTOS', 'the-conference-pro' ) );

    if ( $gallery_btn_label ){
        return esc_html( $gallery_btn_label );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_faq_section_selective_refresh' ) ) :
/**
 * Faq section readmore btn
*/
function the_conference_pro_faq_section_selective_refresh(){
    $faq_viewall_label = get_theme_mod( 'faq_viewall_label', __( 'VIEW ALL', 'the-conference-pro' ) );

    if ( $faq_viewall_label ){
        return esc_html( $faq_viewall_label );
    } else {
        return false;
    }
}
endif;

if( ! function_exists( 'the_conference_pro_blog_section_title_selective_refresh' ) ) :
/**
 * Display blog section title
*/
function the_conference_pro_blog_section_title_selective_refresh(){
    $blog_section_title = get_theme_mod( 'blog_section_title',  __( 'Recent Posts', 'the-conference-pro' ) );

    if ( $blog_section_title ){
        return esc_html( $blog_section_title );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_blog_section_description_selective_refresh' ) ) :
/**
 * Display blog section description
*/
function the_conference_pro_blog_section_description_selective_refresh(){
    $blog_section_subtitle = get_theme_mod( 'blog_section_subtitle',  __( 'See what other people are saying about us', 'the-conference-pro' ) );

    if ( $blog_section_subtitle ){
        return wpautop( wp_kses_post( $blog_section_subtitle ) );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_blog_section_description_selective_refresh' ) ) :
/**
 * Display blog section description
*/
function the_conference_pro_blog_section_description_selective_refresh(){
    $blog_section_subtitle = get_theme_mod( 'blog_section_subtitle',  __( 'See what other people are saying about us', 'the-conference-pro' ) );

    if ( $blog_section_subtitle ){
        return wpautop( wp_kses_post( $blog_section_subtitle ) );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_blog_section_view_all_btn_selective_refresh' ) ) :
/**
 * Display blog section readmore
*/
function the_conference_pro_blog_section_view_all_btn_selective_refresh(){
    $blog_view_all = get_theme_mod( 'blog_view_all',  __( 'SEE ALL POSTS', 'the-conference-pro' ) );

    if ( $blog_view_all ){
        return esc_html( $blog_view_all );
    } else {
        return false;
    }                                                              
}
endif;

/**
 * About Page Template
 */

if( ! function_exists( 'the_conference_pro_about_template_testimonial_viewall_label' ) ) :
/**
 * About template viewall btn
*/
function the_conference_pro_about_template_testimonial_viewall_label(){
    $about_testimonial_viewall_label = get_theme_mod( 'about_testimonial_viewall_label', __( 'SEE ALL TESTIMONIALS', 'the-conference-pro' ) );

    if ( $about_testimonial_viewall_label ){
        return esc_html( $about_testimonial_viewall_label );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_about_timer_cta_title_selective_refresh' ) ) :
/**
 * About template timer cta title
*/
function the_conference_pro_about_timer_cta_title_selective_refresh(){
    $about_timer_cta_title = get_theme_mod( 'about_timer_cta_title', __( 'Hurry Up For Early Bird Tickets!', 'the-conference-pro' ) );

    if ( $about_timer_cta_title ){
        return esc_html( $about_timer_cta_title );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_about_timer_cta_description_selective_refresh' ) ) :
/**
 * About template timer cta description
*/
function the_conference_pro_about_timer_cta_description_selective_refresh(){
    $about_timer_cta_description = get_theme_mod( 'about_timer_cta_description', __( 'See what other people are saying about us', 'the-conference-pro' ) );

    if ( $about_timer_cta_description ){
        return wpautop( wp_kses_post( $about_timer_cta_description ) );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_get_about_timer_cta_readmore_label' ) ) :
/**
 * About template timer cta readmore
*/
function the_conference_pro_get_about_timer_cta_readmore_label(){
    $about_timer_cta_readmore_label = get_theme_mod( 'about_timer_cta_readmore_label', __( 'BUY TICKET NOW', 'the-conference-pro' ) );

    if ( $about_timer_cta_readmore_label ){
        return esc_html( $about_timer_cta_readmore_label );
    } else {
        return false;
    }                                                              
}
endif;

/**
 * Schedule page template 
 */

if( ! function_exists( 'the_conference_pro_schedule_template_section_title' ) ) :
/**
 * Schedule template section title
*/
function the_conference_pro_schedule_template_section_title(){
    $st_section_title = get_theme_mod( 'st_section_title', __( 'Event Programme', 'the-conference-pro' ) );

    if ( $st_section_title ){
        return esc_html( $st_section_title );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_schedule_template_section_description' ) ) :
/**
 * Schedule template section description
*/
function the_conference_pro_schedule_template_section_description(){
    $st_section_description = get_theme_mod( 'st_section_description', __( 'Don\'t Miss a Thing', 'the-conference-pro' ) );

    if ( $st_section_description ){
        return wpautop( wp_kses_post( $st_section_description ) );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_schedule_template_ticket_readmore' ) ) :
/**
 * Schedule template ticket readmore
*/
function the_conference_pro_schedule_template_ticket_readmore(){
    $st_ticket_readmore = get_theme_mod( 'st_ticket_readmore', __( 'BUY TICKET NOW', 'the-conference-pro' ) );

    if ( $st_ticket_readmore ){
        return esc_html( $st_ticket_readmore );
    } else {
        return false;
    }                                                              
}
endif;

/**
 * Gallery page template 
 */

if( ! function_exists( 'the_conference_pro_gallery_template_section_title' ) ) :
/**
 * Gallery template section title
*/
function the_conference_pro_gallery_template_section_title(){
    $gt_section_title = get_theme_mod( 'gt_section_title', __( 'Image Gallery', 'the-conference-pro' ) );

    if ( $gt_section_title ){
        return esc_html( $gt_section_title );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_gallery_template_section_description' ) ) :
/**
 * Gallery template section description
*/
function the_conference_pro_gallery_template_section_description(){
    $gt_section_description = get_theme_mod( 'gt_section_description', __( 'explore our past events and enjoy!', 'the-conference-pro' ) );

    if ( $gt_section_description ){
        return wpautop( wp_kses_post( $gt_section_description ) );
    } else {
        return false;
    }                                                              
}
endif;

if( ! function_exists( 'the_conference_pro_get_related_title' ) ) :
/**
 * Display blog readmore button
*/
function the_conference_pro_get_related_title(){
    return get_theme_mod( 'related_post_title', __( 'Recommended Articles', 'the-conference-pro' ) );
}
endif;

if( ! function_exists( 'the_conference_pro_get_footer_copyright' ) ) :
/**
 * Footer Copyright
*/
function the_conference_pro_get_footer_copyright(){
    $copyright = get_theme_mod( 'footer_copyright' );
    echo '<span class="copyright">';
    if( $copyright ){
        echo wp_kses_post( the_conference_pro_apply_theme_shortcode( $copyright ) );
    }else{
        esc_html_e( '&copy; Copyright ', 'the-conference-pro' );
        echo date_i18n( esc_html__( 'Y', 'the-conference-pro' ) );
        echo ' <a href="' . esc_url( home_url( '/' ) ) . '">' . esc_html( get_bloginfo( 'name' ) ) . '</a>. ';
        esc_html_e( 'All Rights Reserved. ', 'the-conference-pro' );
    }
    echo '</span>'; 
}
endif;

if( ! function_exists( 'the_conference_pro_ed_author_link' ) ) :
/**
 * Show/Hide Author link in footer
*/
function the_conference_pro_ed_author_link(){
    $ed_author_link = get_theme_mod( 'ed_author_link', false );
    
    if( ! $ed_author_link ) {
        echo esc_html__( 'The Conference Pro | Developed By ', 'the-conference-pro' );
        echo '<a href="' . esc_url( 'https://rarathemes.com/' ) .'" rel="nofollow" target="_blank">' . esc_html__( 'Rara Theme', 'the-conference-pro' ) . '</a>.';
    };
}
endif;

if( ! function_exists( 'the_conference_pro_ed_wp_link' ) ) :
/**
 * Show/Hide WordPress link in footer
*/
function the_conference_pro_ed_wp_link(){
    $ed_wp_link = get_theme_mod( 'ed_wp_link', false );
    if( ! $ed_wp_link ) printf( esc_html__( '%1$s Powered by %2$s.%3$s ', 'the-conference-pro' ), '<span class="wp-link">', '<a href="'. esc_url( __( 'https://wordpress.org/', 'the-conference-pro' ) ) .'" target="_blank">WordPress</a>', '</span>' );
}
endif;