<?php
/**
 * Performance Related Functions
 *
 * @package The_Conference_Pro
 */

if( ! function_exists( 'the_conference_pro_image_lazy_load_attr' ) ) :
/**
 * Add data-layzr attribute to featured image ( for lazy load )
 *
 * @param array $attr
 * @param WP_Post $attachment
 * @param string|array $size
 *
 * @return array
 */
function the_conference_pro_image_lazy_load_attr( $attr, $attachment, $size ) {
	$ed_lazyload    = get_theme_mod( 'ed_lazy_load', true );
	$custom_logo_id = get_theme_mod( 'custom_logo' );
    
    if( is_admin() || is_feed() || ( function_exists ( 'is_cart' ) && is_cart() ) ) return $attr;
	
    if( $ed_lazyload && ! is_page_template( 'templates/portfolio.php' ) ){

    	if( $custom_logo_id == $attachment->ID ) {
            return $attr;
        }else{
        	$attr['data-layzr'] = $attr['src'];
			$attr['src'] = 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
			if ( isset( $attr['srcset'] ) ) {
				$attr['data-layzr-srcset'] = $attr['srcset'];
				$attr['srcset'] = '';
			}
        }
	}

	return $attr;
}
endif;
if( class_exists( 'Jetpack' ) ){
	if( ! Jetpack::is_module_active( 'lazy-images' ) ){
		add_filter( 'wp_get_attachment_image_attributes', 'the_conference_pro_image_lazy_load_attr', 10, 3 );
	}
}else{
	add_filter( 'wp_get_attachment_image_attributes', 'the_conference_pro_image_lazy_load_attr', 10, 3 );
}

if( ! function_exists( 'the_conference_pro_content_image_lazy_load_attr' ) ) :
/**
 * Add data-layzr attribute to post content images ( for lazy load )
 *
 * @param string $content
 * @return string
 */
function the_conference_pro_content_image_lazy_load_attr( $content ) {
	$ed_lazyload_content = get_theme_mod( 'ed_lazy_load_cimage', true );
	$page_template = get_page_template_slug( get_queried_object_id() );
	
    if ( $ed_lazyload_content && ! is_page_template( 'templates/portfolio.php' ) && ! empty( $content ) ) {
		$content = preg_replace_callback(
			'/<img([^>]+?)src=[\'"]?([^\'"\s>]+)[\'"]?([^>]*)>/',
			'the_conference_pro_content_image_lazy_load_attr_callback',
			$content
		);
	}

	return $content;
}
endif;
if( class_exists( 'Jetpack' ) ){
	if( ! Jetpack::is_module_active( 'lazy-images' ) ){
		add_filter( 'the_content', 'the_conference_pro_content_image_lazy_load_attr' );
	}
}else{
	add_filter( 'the_content', 'the_conference_pro_content_image_lazy_load_attr' );
}


if( ! function_exists( 'the_conference_pro_content_image_lazy_load_attr_callback' ) ) :
/**
 * Callback to move src to data-src and replace it with a 1x1 tranparent image.
 *
 * @param $matches
 * @return string
 */
function the_conference_pro_content_image_lazy_load_attr_callback( $matches ) {
	$transparent_img = 'data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==';
	if ( preg_match( '/ data-lazy *= *"false" */', $matches[0] ) ) {
		return '<img' . $matches[1] . 'src="' . $matches[2] . '"' . $matches[3] . '>';
	} else {
		return '<img' . $matches[1] . 'src="' . $transparent_img . '" data-layzr="' . $matches[2] . '"' . str_replace( 'srcset=', 'data-layzr-srcset=', $matches[3]). '>';
	}
}
endif;

if ( ! function_exists( 'the_conference_pro_js_async_attr' ) ) :
/**
 * 
*/
function the_conference_pro_js_async_attr( $tag ){
	
	if( is_admin() ) return $tag;
    
	$async_files = apply_filters( 'the_conference_pro_js_async_files', array( 
		get_template_directory_uri() . '/js/ajax.min.js',
		get_template_directory_uri() . '/js/all.min.js',
		get_template_directory_uri() . '/js/custom.min.js',		
		get_template_directory_uri() . '/js/jquery.counterup.min.js',
		get_template_directory_uri() . '/js/jquery.flashy.min.js',
		get_template_directory_uri() . '/js/jquery.mCustomScrollbar.min.js',
		get_template_directory_uri() . '/js/jquery.nav.min.js',
		get_template_directory_uri() . '/js/layzr.min.js',
        get_template_directory_uri() . '/js/owl.carousel.min.js',	
        get_template_directory_uri() . '/js/shims.min.js',	
        get_template_directory_uri() . '/js/sticky-kit.min.js',	
        get_template_directory_uri() . '/js/v4-shims.min.js',	
        get_template_directory_uri() . '/js/waypoints.min.js',	
        get_template_directory_uri() . '/js/wow.min.js',
	 ) );
	
	$add_async = false;
	foreach( $async_files as $file ){
		if( strpos( $tag, $file ) !== false ){
			$add_async = true;
			break;
		}
	}

	if( $add_async && get_theme_mod( 'ed_defer', true ) ) $tag = str_replace( ' src', ' defer="defer" src', $tag );

	return $tag;
}
endif;
add_filter( 'script_loader_tag', 'the_conference_pro_js_async_attr', 10 );

if ( ! function_exists( 'the_conference_pro_remove_script_version' ) ) :
/**
 * Remove Script/Style version parameter
*/
function the_conference_pro_remove_script_version( $src ){
	
	if ( is_admin() )
		return $src;
    
    if( get_theme_mod( 'ed_ver', true ) ){
        $parts = explode( '?ver', $src );
        return $parts[0];
    }else{
        return $src;
    }	
}
endif;
add_filter( 'script_loader_src', 'the_conference_pro_remove_script_version', 15, 1 );
add_filter( 'style_loader_src', 'the_conference_pro_remove_script_version', 15, 1 );