<?php
/**
 * The Conference Pro Template Functions which enhance the theme by hooking into WordPress
 *
 * @package The_Conference_Pro
 */

if( ! function_exists( 'the_conference_pro_doctype' ) ) :
/**
 * Doctype Declaration
*/
function the_conference_pro_doctype(){ ?>
    <!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <?php
}
endif;
add_action( 'the_conference_pro_doctype', 'the_conference_pro_doctype' );

if( ! function_exists( 'the_conference_pro_head' ) ) :
/**
 * Before wp_head 
*/
function the_conference_pro_head(){ ?>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php
}
endif;
add_action( 'the_conference_pro_before_wp_head', 'the_conference_pro_head' );

if( ! function_exists( 'the_conference_pro_page_start' ) ) :
/**
 * Page Start
*/
function the_conference_pro_page_start(){ ?>
    <div class="nav-wrap">
        <?php 
            the_conference_pro_primary_nagivation( true );
            the_conference_pro_custom_header_link();
            the_conference_pro_polylang_language_switcher();
        ?>
    </div>
    <div id="page" class="site">
    <?php
}
endif;
add_action( 'the_conference_pro_before_header', 'the_conference_pro_page_start', 20 );

if( ! function_exists( 'the_conference_pro_header' ) ) :
/**
 * Header Start
*/
function the_conference_pro_header(){ 
    $header_array = array( 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight' );
    $header = get_theme_mod( 'header_layout', 'one' );
    if( in_array( $header, $header_array ) ){            
        get_template_part( 'headers/' . $header );
    }
}
endif;
add_action( 'the_conference_pro_header', 'the_conference_pro_header', 20 );

if( ! function_exists( 'the_conference_pro_banner' ) ) :
/**
 * Banner 
*/
function the_conference_pro_banner(){
    $ed_banner          = get_theme_mod( 'ed_banner_section', 'static_banner' );
    $slider_type        = get_theme_mod( 'slider_type', 'latest_posts' ); 
    $slider_cat         = get_theme_mod( 'slider_cat' );
    $slider_pages       = get_theme_mod( 'slider_pages' );
    $slider_custom      = get_theme_mod( 'slider_custom' );
    $posts_per_page     = get_theme_mod( 'no_of_slides', 3 );
    $ed_full_image      = get_theme_mod( 'slider_full_image', false );
    $ed_caption         = get_theme_mod( 'slider_caption', true );
    $read_more          = get_theme_mod( 'slider_readmore', __( 'Continue Reading', 'the-conference-pro' ) );
    $banner_title       = get_theme_mod( 'banner_title', __( 'Lepiza Announces New Design', 'the-conference-pro' ) );
    $banner_subtitle    = get_theme_mod( 'banner_subtitle', __( 'October 10 & 11 - Berlin, Germany', 'the-conference-pro' ) );
    $banner_label_one   = get_theme_mod( 'banner_label_one', __( 'VIEW SCHEDULE', 'the-conference-pro' ) );
    $banner_link_one    = get_theme_mod( 'banner_link_one', '#' );
    $banner_label_two   = get_theme_mod( 'banner_label_two', __( 'BUY TICKET NOW', 'the-conference-pro' ) );
    $banner_link_two    = get_theme_mod( 'banner_link_two', '#' );
    $ed_banner_timer    = get_theme_mod( 'ed_banner_event_timer', true );
    $event_date         = get_theme_mod( 'banner_event_timer', '2022-08-20' );
    $event_time         = get_theme_mod( 'banner_event_time', '00:00' );
    $banner_newsletter  = get_theme_mod( 'banner_newsletter' );
    $image_size         = $ed_full_image ? 'full' : 'the-conference-banner-slider';
    
    if( is_front_page() && ! is_home() ){ 
        if( ( $ed_banner == 'static_banner' || $ed_banner == 'static_nl_banner' ) && has_custom_header() ){ ?>
            <div id="banner_section" class="site-banner<?php if( has_header_video() ) echo esc_attr( ' video-banner' ); ?>">
                <?php 
                    echo '<div class="item">';

                    the_custom_header_markup(); 

                    echo '<span class="scroll-down"></span>';
                    
                    if( $ed_banner == 'static_banner' && ( $banner_title || $banner_subtitle || ( $banner_label_one && $banner_link_one ) || ( $banner_label_two && $banner_link_two ) ) ){
                        echo '<div class="banner-caption static-banner"><div class="container">';
                        if( $banner_title ) echo '<h2 class="banner-title wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.1s">' . esc_html( $banner_title ) . '</h2>';
                        if( $banner_subtitle ) echo '<div class="banner-desc wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">' . wpautop( wp_kses_post( $banner_subtitle ) ) . '</div>';

                        if( ( $banner_label_one && $banner_link_one ) || ( $banner_label_two && $banner_link_two ) ){
                            echo '<div class="btn-wrap">';
                            if( $banner_label_one && $banner_link_one ) echo '<a href="' . esc_url( $banner_link_one ) . '" class="btn-transparent wow fadeInLeft" data-wow-duration="1s" data-wow-delay="0.5s">' . esc_html( $banner_label_one ) . '</a>';
                            if( $banner_label_two && $banner_link_two ) echo '<a href="' . esc_url( $banner_link_two ) . '" class="btn-filled wow fadeInRight" data-wow-duration="1s" data-wow-delay="0.5s">' . esc_html( $banner_label_two ) . '</a>';
                            echo '</div>';
                        } 
                        
                        if( $ed_banner_timer && $event_date && $event_time ){ ?>
                            <div id="bannerClock" class="banner-countdown wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s">
                                <div class="countdown-wrap">
                                    <span class="days">00</span>
                                    <div class="smalltext"><?php esc_html_e( 'Days', 'the-conference-pro' ); ?></div>
                                </div>
                                <div class="countdown-wrap">
                                    <span class="hours">00</span>
                                    <div class="smalltext"><?php esc_html_e( 'Hours', 'the-conference-pro' ); ?></div>
                                </div>
                                <div class="countdown-wrap">
                                    <span class="minutes">00</span>
                                    <div class="smalltext"><?php esc_html_e( 'Minutes', 'the-conference-pro' ); ?></div>
                                </div>
                                <div class="countdown-wrap">
                                    <span class="seconds">00</span>
                                    <div class="smalltext"><?php esc_html_e( 'Seconds', 'the-conference-pro' ); ?></div>
                                </div>
                            </div>
                            <?php
                        }
                        echo '</div></div>';
                    }elseif( $ed_banner == 'static_nl_banner' ){
                        echo '<div class="banner-caption newsletter-banner"><div class="container">';
                            if ( $banner_newsletter ) echo do_shortcode( wp_kses_post( $banner_newsletter ) );
                        echo '</div></div>';
                    }   
                    echo '</div>';
                    
                ?>
            </div>
        <?php
        }elseif( $ed_banner == 'slider_banner' ){
            if( $slider_type == 'latest_posts' || $slider_type == 'cat' || $slider_type == 'pages' ){
                $image_size = $ed_full_image ? 'full' : 'the-conference-banner-slider';
                $args = array(
                    'post_status'         => 'publish',            
                    'ignore_sticky_posts' => true
                );
                
                if( $slider_type === 'cat' && $slider_cat ){
                    $args['post_type']      = 'post';
                    $args['cat']            = $slider_cat; 
                    $args['posts_per_page'] = -1;  
                }elseif( $slider_type == 'pages' && $slider_pages ){
                    $args['post_type']      = 'page';
                    $args['posts_per_page'] = -1;
                    $args['post__in']       = the_conference_pro_get_id_from_page( $slider_pages );
                    $args['orderby']        = 'post__in';
                }else{
                    $args['post_type']      = 'post';
                    $args['posts_per_page'] = $posts_per_page;
                }
                    
                $qry = new WP_Query( $args );
                
                if( $qry->have_posts() ){ ?>
                    <div id="banner_section" class="site-banner">
                        <div id="banner-slider" class="owl-carousel">            
                        <?php while( $qry->have_posts() ){ $qry->the_post(); ?>
                        <div class="item">
                            <?php 
                            if( has_post_thumbnail() ){
                                the_post_thumbnail( $image_size, array( 'itemprop' => 'image' ) );    
                            }else{ 
                                the_conference_pro_fallback_image( $image_size );
                            }

                            echo '<span class="scroll-down"></span>';
                            
                            if( $ed_caption ){ ?>                        
                            <div class="banner-caption">
                                <div class="container">
                                    <div class="text-holder">
                                        <?php
                                            the_title( '<h2 class="banner-title wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.1s"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                                            if( $read_more ) echo '<div class="btn-wrap"><a class="btn-transparent wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s" href="' . esc_url( get_the_permalink() ) . '" class="btn-more">' . esc_html( $read_more ) . '</a></div>';                              
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                        <?php } ?>                        
                    </div>                
                </div>
                <?php
                wp_reset_postdata();
                }
            
            }elseif( $slider_type == 'custom' && $slider_custom ){ ?>
                <div id="banner_section" class="site-banner">
                    <div id="banner-slider" class="owl-carousel">
                        <?php 
                        foreach( $slider_custom as $slide ){ 
                            if( $slide['thumbnail'] ){ ?>
                                <div class="item">
                                <?php 
                                    $image = wp_get_attachment_image_url( $slide['thumbnail'], $image_size ); ?>
                                    <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( strip_tags( $slide['title'] ) ); ?>" itemprop="image" />

                                    <?php echo '<span class="scroll-down"></span>'; ?>
                                        
                                    <?php if( $ed_caption && ( $slide['title'] || $slide['subtitle'] ) ){ ?>                        
                                        <div class="banner-caption">
                                            <div class="container">
                                                <div class="text-holder">
                                                    <?php
                                                        if( $slide['title'] ){
                                                            echo '<h2 class="banner-title wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.1s">';
                                                            if( $slide['link'] ) echo '<a href="' . esc_url( $slide['link'] ) . '" rel="bookmark">';
                                                            echo wp_kses_post( $slide['title'] );
                                                            if( $slide['link'] ) echo '</a>';
                                                            echo '</h2>';    
                                                        }
                                                        
                                                        if( $slide['subtitle'] ){
                                                            echo '<div class="banner-desc wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.1s">';
                                                            echo esc_html( $slide['subtitle'] ); 
                                                            echo '</div>';    
                                                        } 

                                                        if( $read_more && $slide['link'] ) echo '<div class="btn-wrap"><a class="btn-transparent wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s" href="' . esc_url( $slide['link'] ) . '" class="btn-more">' . esc_html( $read_more ) . '</a></div>';                            
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            <?php 
                            } 
                        } 
                        ?>                        
                    </div>            
                </div>
                <?php
            }
        }
    }
}
endif;
add_action( 'the_conference_pro_after_header', 'the_conference_pro_banner' );

if( ! function_exists( 'the_conference_pro_content_start' ) ) :
/**
 * Content Start
 * 
*/
function the_conference_pro_content_start(){  
    $home_sections = the_conference_pro_get_home_sections();

    if( is_front_page() && ! is_home() ){
        if( empty( $home_sections ) ){
            echo '<div id="content" class="site-content"><div class="container">';
        }
    }else{ ?>     
        <div id="content" class="site-content">
        <?php 
            the_conference_pro_header_banner();
            if( ! is_page_template( array( 'templates/about.php', 'templates/contact.php', 'templates/schedule.php', 'templates/gallery.php', 'templates/speaker.php', 'templates/ticket.php', 'templates/sponsor.php', 'templates/testimonial.php', 'templates/venue.php'  ) ) ){
                echo '<div class="container">';
            }
    }   
}
endif;
add_action( 'the_conference_pro_content', 'the_conference_pro_content_start' );

if( ! function_exists( 'the_conference_pro_entry_header' ) ) :
/**
 * Entry Header
*/
function the_conference_pro_entry_header(){
    $blog_layout = get_theme_mod( 'blog_page_layout', 'classic-view' );

    if( ! ( ( is_home() && 'classic-view' == $blog_layout ) || ( is_single() || is_page() ) ) ){
        echo '<div class="post-content-wrap">';
    }
    ?>
    <header class="entry-header">
		<?php 
            $hide_post_date     = get_theme_mod( 'ed_post_date', false );
            $hide_comment_count = get_theme_mod( 'ed_post_comment_count', false );
            ?>

            <h2 class="entry-title" itemprop="headline">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h2>
            
            <?php if( ! $hide_comment_count || ! $hide_post_date ){ ?>
                <div class="entry-meta">
                    <?php 
                        if( ! $hide_post_date ) the_conference_pro_posted_on();
                        if( ! $hide_comment_count ) the_conference_pro_comment_count();
                    ?>
                </div>
            <?php } 
        ?>
	</header>         
    <?php    
}
endif;
add_action( 'the_conference_pro_before_posts_entry_content', 'the_conference_pro_entry_header', 20 );

if ( ! function_exists( 'the_conference_pro_post_thumbnail' ) ) :
/**
 * Displays an optional post thumbnail.
 *
 * Wraps the post thumbnail in an anchor element on index views, or a div
 * element when on single views.
 */
function the_conference_pro_post_thumbnail() {
    $hide_category  = get_theme_mod( 'ed_category', false );
    $home_layout    = get_theme_mod( 'blog_page_layout', 'classic-view' );
    $sidebar_layout = the_conference_pro_sidebar( true ); 
    $ed_crop_archive_page_image = get_theme_mod( 'ed_crop_archive_page_image' ); 

    if( is_home() || is_archive() || is_search() ){
        echo '<figure class="post-thumbnail">';
        if( ! $hide_category ) the_conference_pro_category();

        echo '<a href="' . esc_url( get_permalink() ) . '" class="post-thumbnail">';
            if( is_home() ){
                $thumbnail_size = 'the-conference-blog';
                if( 'full-width' == $sidebar_layout &&  'classic-view' == $home_layout ){
                    $thumbnail_size = 'the-conference-blog-fullwidth';
                }

                if( has_post_thumbnail() ){
                   $ed_crop_archive_page_image ? the_post_thumbnail() : the_post_thumbnail( $thumbnail_size, array( 'itemprop' => 'image' ) );    
                }else{
                    the_conference_pro_fallback_image( $thumbnail_size );
                }
            }else{
                if( has_post_thumbnail() ){
                    $ed_crop_archive_page_image ? the_post_thumbnail() : the_post_thumbnail( 'the-conference-blog', array( 'itemprop' => 'image' ) );    
                }else{
                    the_conference_pro_fallback_image( 'the-conference-blog' );
                }
            }
        echo '</a>';

        echo '</figure>';
    }
}
endif;
add_action( 'the_conference_pro_before_posts_entry_content', 'the_conference_pro_post_thumbnail', 15 );

if( ! function_exists( 'the_conference_pro_entry_content' ) ) :
/**
 * Entry Content
*/
function the_conference_pro_entry_content(){ 
    $ed_excerpt = get_theme_mod( 'ed_excerpt', true ); ?>
    <div class="entry-content" itemprop="text">
		<?php
			if( is_singular() || ! $ed_excerpt || ( get_post_format() != false ) ){
                the_content();    
    			wp_link_pages( array(
    				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'the-conference-pro' ),
    				'after'  => '</div>',
    			) );
            }else{
                the_excerpt();
            }
		?>
	</div><!-- .entry-content -->
    <?php
}
endif;
add_action( 'the_conference_pro_page_entry_content', 'the_conference_pro_entry_content', 15 );
add_action( 'the_conference_pro_post_entry_content', 'the_conference_pro_entry_content', 15 );
add_action( 'the_conference_pro_posts_entry_content', 'the_conference_pro_entry_content', 15 );

if( ! function_exists( 'the_conference_pro_entry_footer' ) ) :
/**
 * Entry Footer
*/
function the_conference_pro_entry_footer(){
    $hide_tags  = get_theme_mod( 'ed_tags', false ); 
    $blog_layout = get_theme_mod( 'blog_page_layout', 'classic-view' );
    $readmore = get_theme_mod( 'read_more_text', __( 'CONTINUE READING', 'the-conference-pro' ) ); ?>
	<footer class="entry-footer">
		<?php
			if( is_single() && 'post' == get_post_type() && ! $hide_tags  ){
			    the_conference_pro_tag();
			}
            
            if( is_home() || is_archive() || is_search() ){
                echo '<a href="' . esc_url( get_the_permalink() ) . '" class="btn-transparent">' . esc_html( $readmore ) . '<i class="fas fa-long-arrow-alt-right"></i></a>';    
            }
            
            if( get_edit_post_link() ){
                edit_post_link(
					sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Edit <span class="screen-reader-text">%s</span>', 'the-conference-pro' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						get_the_title()
					),
					'<span class="edit-link">',
					'</span>'
				);
            }
		?>
	</footer><!-- .entry-footer -->
	<?php 
    if( ! ( ( is_home() && 'classic-view' == $blog_layout ) || ( is_single() || is_page() ) ) ){
        echo '</div><!-- .post-content-wrap -->';
    }
}
endif;
add_action( 'the_conference_pro_page_entry_content', 'the_conference_pro_entry_footer', 20 );
add_action( 'the_conference_pro_post_entry_content', 'the_conference_pro_entry_footer', 20 );
add_action( 'the_conference_pro_posts_entry_content', 'the_conference_pro_entry_footer', 20 );

if( ! function_exists( 'the_conference_pro_navigation' ) ) :
/**
 * Navigation
*/
function the_conference_pro_navigation(){
    if( is_single() ){
        $previous = get_previous_post_link(
    		'<div class="nav-previous nav-holder">%link</div>',
    		'<span class="meta-nav"><i class="fa fa-long-arrow-alt-left"></i>' . esc_html__( 'Previous Article', 'the-conference-pro' ) . '</span><span class="post-title">%title</span>',
    		false,
    		'',
    		'category'
    	);
    
    	$next = get_next_post_link(
    		'<div class="nav-next nav-holder">%link</div>',
    		'<span class="meta-nav"><i class="fa fa-long-arrow-alt-right"></i>' . esc_html__( 'Next Article', 'the-conference-pro' ) . '</span><span class="post-title">%title</span>',
    		false,
    		'',
    		'category'
    	); 
        
        if( $previous || $next ){?>            
            <nav class="navigation post-navigation" role="navigation">
    			<h2 class="screen-reader-text"><?php esc_html_e( 'Post Navigation', 'the-conference-pro' ); ?></h2>
    			<div class="nav-links">
    				<?php
                        if( $previous ) echo $previous;
                        if( $next ) echo $next;
                    ?>
    			</div>
    		</nav>        
            <?php
        }
    }else{
        $pagination = get_theme_mod( 'pagination_type', 'numbered' );
        
        switch( $pagination ){
            case 'default': // Default Pagination
            
            the_posts_navigation();
            
            break;
            
            case 'numbered': // Numbered Pagination
            
            the_posts_pagination( array(
                'prev_text'          => __( '<span class="arrow">&larr;</span> PREV', 'the-conference-pro' ),
                'next_text'          => __( 'NEXT<span class="arrow">&rarr;</span>', 'the-conference-pro' ),
                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'the-conference-pro' ) . ' </span>',
            ) );
            
            break;
            
            case 'load_more': // Load More Button
            case 'infinite_scroll': // Auto Infinite Scroll
            
            echo '<div class="pagination"></div>';
            
            break;
            
            default:
            
            the_posts_navigation();
            
            break;
        }
    }
}
endif;
add_action( 'the_conference_pro_after_post_content', 'the_conference_pro_navigation', 15 );
add_action( 'the_conference_pro_after_posts_content', 'the_conference_pro_navigation' );

if( ! function_exists( 'the_conference_pro_author' ) ) :
/**
 * Author Section
*/
function the_conference_pro_author(){ 
    $ed_author   = get_theme_mod( 'ed_author', false );
    $author_name = get_the_author_meta( 'display_name' );
    $author_bio  = get_the_author_meta( 'description' );

    if( ! $ed_author && $author_bio ){ ?>
        <div class="about-author">
            <figure class="author-img">
                <?php echo get_avatar( get_the_author_meta( 'ID' ), 120 ); ?>
            </figure>
            <div class="author-content-wrap">
                <?php 
                    if( $author_name ){ 
                        echo '<h3 class="author-name"><span class="title-wrap">'. esc_html( $author_name ) .'</span></h3>';
                    }

                    if( $author_bio ){
                        echo '<div class="author-info">'. wpautop( wp_kses_post( $author_bio ) ) .'</div>';
                    }

                    the_conference_pro_author_social();
                ?>
            </div>
        </div> <!-- .about-author -->
    <?php
    }
}
endif;
add_action( 'the_conference_pro_after_post_content', 'the_conference_pro_author', 25 );

if( ! function_exists( 'the_conference_pro_related_posts' ) ) :
/**
 * Related Posts 
*/
function the_conference_pro_related_posts(){ 
    $ed_related_post = get_theme_mod( 'ed_related', true );

    if( $ed_related_post ){
        the_conference_pro_get_posts_list( 'related' );    
    }
}
endif;                                                                               
add_action( 'the_conference_pro_after_post_content', 'the_conference_pro_related_posts', 35 );

if( ! function_exists( 'the_conference_pro_latest_posts' ) ) :
/**
 * Latest Posts
*/
function the_conference_pro_latest_posts(){ 
    the_conference_pro_get_posts_list( 'latest' );
}
endif;
add_action( 'the_conference_pro_latest_posts', 'the_conference_pro_latest_posts' );

if( ! function_exists( 'the_conference_pro_comment' ) ) :
/**
 * Comments Template 
*/
function the_conference_pro_comment(){
    // If comments are open or we have at least one comment, load up the comment template.
	if( get_theme_mod( 'ed_comments', true ) && ( comments_open() || get_comments_number() ) ) :
		comments_template();
	endif;
}
endif;
add_action( 'the_conference_pro_after_post_content', 'the_conference_pro_comment', 45 );
add_action( 'the_conference_pro_after_page_content', 'the_conference_pro_comment' );

if( ! function_exists( 'the_conference_pro_content_end' ) ) :
/**
 * Content End
*/
function the_conference_pro_content_end(){ 
    $home_sections = the_conference_pro_get_home_sections();

    if( is_front_page() && ! is_home() ){
        if( empty( $home_sections ) ){
            echo '</div></div><!-- .conatiner -->';
        }
    }else{ 
        if( ! is_page_template( array( 'templates/about.php', 'templates/contact.php', 'templates/schedule.php', 'templates/gallery.php', 'templates/speaker.php', 'templates/ticket.php', 'templates/sponsor.php', 'templates/testimonial.php', 'templates/venue.php' ) ) ) echo ' </div><!-- .container/ -->';
        ?>      
        </div><!-- .site-content -->
    <?php
    }
}
endif;
add_action( 'the_conference_pro_before_footer', 'the_conference_pro_content_end', 20 );

if( ! function_exists( 'the_conference_pro_newsletter_section' ) ) :
/**
 * Newsletter Section
*/
function the_conference_pro_newsletter_section(){ 
    $ed_newsletter = get_theme_mod( 'ed_newsletter', false );
    $ed_gradient   = get_theme_mod( 'ed_newsletter_gradient', true );
    $newsletter    = get_theme_mod( 'newsletter_shortcode' );
    $class         = $ed_gradient ? ' gradient-enabled' : '';

    if( $ed_newsletter && $newsletter ){ ?>
        <section id="newsletter_section" class="newsletter-section<?php echo esc_attr( $class ); ?>">
            <div class="wrapper">
                <?php echo do_shortcode( wp_kses_post( $newsletter ) ); ?>
            </div>
        </section> <!-- .newsletter-section -->
    <?php    
    }
}
endif;
add_action( 'the_conference_pro_before_footer', 'the_conference_pro_newsletter_section', 25 );

if( ! function_exists( 'the_conference_pro_footer_start' ) ) :
/**
 * Footer Start
*/
function the_conference_pro_footer_start(){
    ?>
    <footer id="colophon" class="site-footer" itemscope itemtype="https://schema.org/WPFooter">
    <?php
}
endif;
add_action( 'the_conference_pro_footer', 'the_conference_pro_footer_start', 20 );

if( ! function_exists( 'the_conference_pro_footer_top' ) ) :
/**
 * Footer Top
*/
function the_conference_pro_footer_top(){    
    $footer_sidebars = array( 'footer-one', 'footer-two', 'footer-three', 'footer-four' );
    $active_sidebars = array();
    $sidebar_count   = 0;
    
    foreach ( $footer_sidebars as $sidebar ) {
        if( is_active_sidebar( $sidebar ) ){
            array_push( $active_sidebars, $sidebar );
            $sidebar_count++ ;
        }
    }
                 
    if( $active_sidebars ){ ?>
        <div class="top-footer">
    		<div class="container">
    			<div class="grid column-<?php echo esc_attr( $sidebar_count ); ?>">
                <?php foreach( $active_sidebars as $active ){ ?>
    				<div class="col">
    				   <?php dynamic_sidebar( $active ); ?>	
    				</div>
                <?php } ?>
                </div>
    		</div>
    	</div>
        <?php 
    }
}
endif;
add_action( 'the_conference_pro_footer', 'the_conference_pro_footer_top', 30 );

if( ! function_exists( 'the_conference_pro_footer_bottom' ) ) :
/**
 * Footer Bottom
*/
function the_conference_pro_footer_bottom(){ ?>
    <div class="bottom-footer">
		<div class="container">
			<div class="site-info">            
            <?php
                the_conference_pro_get_footer_copyright();
                the_conference_pro_ed_author_link();
                the_conference_pro_ed_wp_link();
                
                if ( function_exists( 'the_privacy_policy_link' ) ) {
                    the_privacy_policy_link();
                }
            ?>               
            </div>
		</div>
	</div>
    <?php
}
endif;
add_action( 'the_conference_pro_footer', 'the_conference_pro_footer_bottom', 40 );

if( ! function_exists( 'the_conference_pro_footer_end' ) ) :
/**
 * Footer End 
*/
function the_conference_pro_footer_end(){ ?>
    </footer><!-- #colophon -->
    <?php
}
endif;
add_action( 'the_conference_pro_footer', 'the_conference_pro_footer_end', 50 );

if( ! function_exists( 'the_conference_pro_back_to_top' ) ) :
/**
 * Back to top
*/
function the_conference_pro_back_to_top(){ 
    $enable_scroll_top = get_theme_mod( 'ed_scroll_to_top', true );

    if( $enable_scroll_top ){ ?>
        <div id="back-to-top" class="scroll-to-top">
    		<span><i class="fas fa-long-arrow-alt-up"></i></span>
    	</div>
    <?php
    }
}
endif;
add_action( 'the_conference_pro_after_footer', 'the_conference_pro_back_to_top', 15 );

if( ! function_exists( 'the_conference_pro_page_end' ) ) :
/**
 * Page End
*/
function the_conference_pro_page_end(){ ?>
    </div><!-- #page -->
    <?php
}
endif;
add_action( 'the_conference_pro_after_footer', 'the_conference_pro_page_end', 20 );


if( ! function_exists( 'the_conference_pro_post_count' ) ) :
/**
 * Post counts in search and archive page.
*/
function the_conference_pro_post_count(){
    if( is_search() || is_archive() || is_author() ){
        global $wp_query;
        $found_posts  = $wp_query->found_posts;
        $paged        = get_query_var( 'paged', 0 );
        $visible_post = get_option( 'posts_per_page' );
        $paged_index  = $found_posts / $visible_post;

        if( $found_posts > 0 && $found_posts > $visible_post ){
            if( $paged == 0 ){
                $start_post = 1;
                $end_post = $visible_post;
            }elseif( $paged < $paged_index ){
                $start_post = ( ( $paged - 1 ) * $visible_post ) + 1;
                $end_post = $paged * $visible_post;
            }else{
                $start_post = ( ( $paged - 1 ) * $visible_post ) + 1;
                $end_post = ( $paged - 1 ) * $visible_post + ( $found_posts - ( ( $paged - 1 ) * $visible_post ) );
            }
            echo '<div class="post-count">Showing: '. $start_post .' - '.  number_format_i18n( $end_post ) .' of '. number_format_i18n( $found_posts ).' RESULTS</div>';
        }elseif( $found_posts > 0 ){
            /* translators: 1: found posts. */
            echo '<div class="post-count">'. sprintf( _nx( '%s RESULT', '%s RESULTS', $found_posts, 'found posts', 'the-conference-pro' ), number_format_i18n( $found_posts ) ) .'</div>';
        }
    }        
}
endif;
add_action( 'the_conference_pro_before_posts_content', 'the_conference_pro_post_count' );