<?php
/**
 * Pricing Table Widget
 *
 * @package The_Conference_Pro
 */

 /**
 * Adds The_Conference_Pro_Pricing_Table_Widget widget.
 */
class The_Conference_Pro_Pricing_Table_Widget extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        add_action( 'admin_print_footer_scripts', array( $this,'the_conference_pro_item_template' ) );
        parent::__construct(
			'cp_pt_widget', // Base ID
			__( 'RARA: Pricing Table Widget', 'the-conference-pro' ), // Name
			array( 
                'class' => 'cp_pt_widget our-pricing',
                'description' => __( 'A Pricing Table Widget.', 'the-conference-pro' ),
            ) // Args
		);
    }

    /**
    * 
    * Items template.
    *
    * @since 1.0.0
    */
    function the_conference_pro_item_template() { ?>
        
        <div class="cp-item-template">
            <li class="cp-items-wrap">
                <p>
                    <input class="items-length" name="<?php echo esc_attr( $this->get_field_name( 'items[{{indexed}}]' ) ); ?>" type="text" value="" />
                    <span class="cp-del-item dashicons-no" style="font-family: 'dashicons'"></span>
                </p>
            </li>
        </div>
    <?php
        }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        
        $best_packgage = ! empty( $instance['best_packgage'] ) ? $instance['best_packgage'] : '' ;
        $best_label    = ! empty( $instance['best_label'] ) ? $instance['best_label'] : '' ;
        $title         = ! empty( $instance['title'] ) ? $instance['title'] : '' ;  
        $currency      = ! empty( $instance['currency'] ) ? $instance['currency'] : '';
        $price         = ! empty( $instance['price'] ) ? $instance['price'] : '';
        $time          = ! empty( $instance['time'] ) ? $instance['time'] : '';
        $label         = ! empty( $instance['label'] ) ? $instance['label'] : '';
        $link          = ! empty( $instance['link'] ) ? $instance['link'] : '';

        echo $args['before_widget'];

        $class = $best_packgage ? ' has-tag' : ''; 
        ?>
            <div class="pricingtable-block<?php echo esc_attr( $class ); ?>">
                <div class="pricing-header">
                    <?php 
                        if( $best_packgage && $best_label ) echo '<div class="pricingtable-tag"><span class="tag-inner">'. esc_html( $best_label ) .'</span></div>';

                        if( $title ) echo '<h3 class="priginttable-title">'. esc_html( $title ) .'</h3>'; 

                        if( $price ) {
                            echo '<div class="pricingtable-price"><sup>'. esc_html( $currency ) .'</sup><span class="price">'. wp_kses_post( $price ) .'</span><span class="price-qty">'. esc_html( $time ) .'</span></div>';
                        }

                    ?>
                </div>
                <?php
                    if( isset( $instance['items'] ) && !empty($instance['items'] ) ){ 
                        echo '<div class="pricingtable-desc"><ul>';

                            $items  = $instance['items'];
                            $arr_keys  = array_keys( $items );
                            foreach ( $items as $key => $value )
                            { 
                                if ( array_key_exists( $key,$instance['items'] ) ) { ?>
                                    <li class="check"><?php echo wp_kses_post( $instance['items'][$key] ); ?></li>
                                <?php
                                }
                            }

                        echo '</ul></div>';
                    } 

                    if( ! empty( $link ) && ! empty( $label ) ){
                        echo '<div class="pricingtable-btn"><a href="'. esc_url( $link ).'">'. esc_html( $label ) .'</a></div>';
                    }
                ?>
            </div>
        <?php            
        echo $args['after_widget'];
    }

    /**
     * Back-end widget form.
     *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
        $defaults  = array(
            'best_packgage' => 'basic-plan',
            'best_label'    => __( 'Best Package', 'the-conference-pro' ),
            'title'         => '',
            'currency'      => '$',
            'price'         => '',
            'time'          => '/ person',
            'link'          => '',
            'label'         => '',
        );
        $instance = wp_parse_args( (array) $instance, $defaults );

        $best_packgage = $instance['best_packgage'];
        $best_label    = $instance['best_label'];
        $title         = $instance['title'];
        $currency      = $instance['currency'];
        $price         = $instance['price'];
        $time          = $instance['time'];
        $link          = $instance['link'];
        $label         = $instance['label'];
        ?>

		<p>   
            <label for="<?php echo esc_attr( $this->get_field_id( 'best_packgage' ) ); ?>"><?php esc_html_e( 'Best Package', 'the-conference-pro' ); ?></label> 
            <input class="best-package" id="<?php echo esc_attr( $this->get_field_id( 'best_packgage' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'best_packgage' ) ); ?>" type="checkbox" value="1" <?php checked( '1', $best_packgage ); ?>/>
        </p>
        
        <div class="best-package-label" <?php echo isset($best_packgage) && ($best_packgage =='1') ? "style='display:none;'" : "style='display:block;'" ;?>>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'best_label' ) ); ?>"><?php esc_html_e( 'Best Label', 'the-conference-pro' ); ?></label> 
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'best_label' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'best_label' ) ); ?>" type="text" value="<?php echo esc_attr( $best_label ); ?>" />            
            </p>
        </div>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'the-conference-pro' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />            
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'currency' ) ); ?>"><?php esc_html_e( 'Currency', 'the-conference-pro' ); ?></label>
            <input type="text" name="<?php echo esc_attr( $this->get_field_name( 'currency' ) ); ?>" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'currency' ) ); ?>" value="<?php print $currency; ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'price' ) ); ?>"><?php esc_html_e( 'Price', 'the-conference-pro' ); ?></label>
            <input type="text" name="<?php echo esc_attr( $this->get_field_name( 'price' ) ); ?>" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'price' ) ); ?>" value="<?php print $price; ?>">
        </p>

         <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'time' ) ); ?>"><?php esc_html_e( 'Per value', 'the-conference-pro' ); ?></label>
            <input type="text" name="<?php echo esc_attr( $this->get_field_name( 'time' ) ); ?>" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'time' ) ); ?>" value="<?php print $time; ?>">
        </p>
        
        <script type='text/javascript'>
            jQuery(document).ready(function($) {
                $('.cp-sortable-items').sortable({
                    cursor: 'move',
                    update: function (event, ui) {
                        $('ul.cp-sortable-items input').trigger('change');
                    }
                });
            });
        </script>

        <ul class="cp-sortable-items" id="<?php echo esc_attr( $this->get_field_id( 'rara-business-pro-items' ) ); ?>">
            <?php
            if(isset($instance['items']))
            {
                $items  = $instance['items'];
                $arr_keys  = array_keys( $items );
                if(isset($arr_keys)){
                    foreach ($arr_keys as $key => $value)
                    { 
                        if ( array_key_exists( $value,$instance['items'] ) )
                        { 
                            ?>
                                <li class="cp-items-wrap">
                                    <p>
                                        <input class="items-length" name="<?php echo esc_attr( $this->get_field_name( 'items['.$value.']' ) ) ?>" type="text" value="<?php echo esc_attr($instance['items'][$value]);?>" />
                                        <span class="cp-del-item dashicons-no" style="font-family: 'dashicons'"></span>
                                    </p>
                                </li>
                        <?php
                        }
                    }
                }
            }
            ?>
            <div class="cp-items-holder"></div>
        </ul>
        <input class="cp-items-add button-secondary" type="button" value="<?php _e('Add Item','the-conference-pro');?>"><br><br>
        <span class="widget-note"><?php _e('Click the above button to add items. You can sort them as well.','the-conference-pro');?></span>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>"><?php esc_html_e( 'Featured Link', 'the-conference-pro' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'link' ) ); ?>" type="text" value="<?php echo esc_url( $link ); ?>" />            
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'label' ) ); ?>"><?php esc_html_e( 'Label', 'the-conference-pro' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'label' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'label' ) ); ?>" type="text" value="<?php echo esc_attr( $label ); ?>" />            
        </p>
        
        <?php

        echo 
        '<script>
        jQuery(document).ready(function($) {
            var best = document.getElementsByClassName("best-package");
            var checked = ! $(best).is(":checked");
            if( checked )
            {
                $(best).parent().siblings(".best-package-label").hide();
            }
            else{
                $(best).parent().siblings(".best-package-label").show();
            }

            $(".best-package").on("change", function(e) {
                var onclick_checked = $(this).is(":checked");
                if( onclick_checked )
                {
                    $(this).parent().siblings(".best-package-label").show();
                }
                else{
                    $(this).parent().siblings(".best-package-label").hide();
                }
            });
        });
        </script>'; 
	}
    
    /**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		
        $instance['best_packgage'] = absint( $new_instance['best_packgage'] );
        $instance['best_label']    = sanitize_text_field( $new_instance['best_label'] );
        $instance['title']         = sanitize_text_field( $new_instance['title'] );
        $instance['currency']      = sanitize_text_field( $new_instance['currency'] );
        $instance['price']         = wp_kses_post( $new_instance['price'] );
        $instance['time']          = sanitize_text_field( $new_instance['time'] );
        $instance['link']          = sanitize_text_field( $new_instance['link'] );
        $instance['label']         = sanitize_text_field( $new_instance['label'] );

        if(isset($new_instance['items']) && !empty($new_instance['items']))
        {
            $arr_keys  = array_keys( $new_instance['items'] );
                    
            foreach ($arr_keys as $key => $value)
            { 
                if ( array_key_exists( $value,$new_instance['items'] ) )
                { 
                    $instance['items'][$value] =  $new_instance['items'][$value];
                }
            }
        }

        return $instance;
	}
    
}  // class The_Conference_Pro_Pricing_Table_Widget

// register The_Conference_Pro_Pricing_Table_Widget widget
function the_conference_pro_register_pricing_table_widget(){
    register_widget( 'The_Conference_Pro_Pricing_Table_Widget' );
}
add_action('widgets_init', 'the_conference_pro_register_pricing_table_widget');