<?php
/**
 * The Conference Pro Widget Areas
 * 
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 * @package The_Conference_Pro
 */

function the_conference_pro_widgets_init(){    
    $sidebars = array(
        'sidebar'   => array(
            'name'        => __( 'Sidebar', 'the-conference-pro' ),
            'id'          => 'sidebar', 
            'description' => __( 'Default Sidebar', 'the-conference-pro' ),
        ),
        'about' => array(
            'name'        => __( 'About Section', 'the-conference-pro' ),
            'id'          => 'about', 
            'description' => __( 'Add "Rara: A Featured Page Widget" for about section.', 'the-conference-pro' ),
        ),
        'stat-counter' => array(
            'name'        => __( 'Stat Counter Section', 'the-conference-pro' ),
            'id'          => 'stat-counter', 
            'description' => __( 'Add "Rara: Stat Counter Widget" for Stat Counter section.', 'the-conference-pro' ),
        ),
        'recent-conference' => array(
            'name'        => __( 'Recent Conferences Section', 'the-conference-pro' ),
            'id'          => 'recent-conference', 
            'description' => __( 'Add "Rara: Icon Text" Widget for Recent Conferences section.', 'the-conference-pro' ),
        ),
        'speakers' => array(
            'name'        => __( 'Speakers Section', 'the-conference-pro' ),
            'id'          => 'speakers', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Team Member" Widget for Speakers.', 'the-conference-pro' ),
        ),
        'ticket' => array(
            'name'        => __( 'Ticket Section', 'the-conference-pro' ),
            'id'          => 'ticket', 
            'description' => __( 'Add "Text" widget for title and description, Add "RARA: Pricing Table Widget" for Ticket section.', 'the-conference-pro' ),
        ),
        'testimonial' => array(
            'name'        => __( 'Testimonial Section', 'the-conference-pro' ),
            'id'          => 'testimonial', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Testimonial" widget for testimonial section.', 'the-conference-pro' ),
        ),
        'sponsor' => array(
            'name'        => __( 'Sponsor Section', 'the-conference-pro' ),
            'id'          => 'sponsor', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Client Logo" Widget for Sponsors.', 'the-conference-pro' ),
        ),
        'cta' => array(
            'name'        => __( 'Call To Action Section', 'the-conference-pro' ),
            'id'          => 'cta', 
            'description' => __( 'Add "Rara: Call To Action" widget for Call to Action section.', 'the-conference-pro' ),
        ),
        'faq' => array(
            'name'        => __( 'FAQ Section', 'the-conference-pro' ),
            'id'          => 'faq', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: FAQs" widget for frequently asked questions.', 'the-conference-pro' ),
        ),
        'gallery' => array(
            'name'        => __( 'Gallery Section', 'the-conference-pro' ),
            'id'          => 'gallery', 
            'description' => __( 'Add "Text" widget for title and description, Add "Gallery" widget for gallery images.', 'the-conference-pro' ),
        ),
        'contact' => array(
            'name'        => __( 'Contact Section', 'the-conference-pro' ),
            'id'          => 'contact', 
            'description' => __( 'Add "Text" widget for title and description, Add "Text" widget ( use shortcode ) to display contact form and Add "Rara: Contact Widget" Widget for contact details and social links.', 'the-conference-pro' ),
        ),
        'gmap' => array(
            'name'        => __( 'Google Map Section', 'the-conference-pro' ),
            'id'          => 'gmap', 
            'description' => __( 'Add "Custom HTML" widget for Google Map section.', 'the-conference-pro' ),
        ),
        'about-intro' => array(
            'name'        => __( 'About Template Intro Section', 'the-conference-pro' ),
            'id'          => 'about-intro', 
            'description' => __( 'Add "Rara: A Featured Page Widget" for intro section and Add "Rara: Icon Text" widget for services.', 'the-conference-pro' ),
        ),
        'about-experience' => array(
            'name'        => __( 'About Template Experience Section', 'the-conference-pro' ),
            'id'          => 'about-experience', 
            'description' => __( 'Add "Text" widget for title and description, Add "Image" widget for experiences.', 'the-conference-pro' ),
        ),
        'about-speakers' => array(
            'name'        => __( 'About Template Speakers Section', 'the-conference-pro' ),
            'id'          => 'about-speakers', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Team Member" widget for about speakers section.', 'the-conference-pro' ),
        ),
        'about-stat-counter' => array(
            'name'        => __( 'About Template Stat Counter Section', 'the-conference-pro' ),
            'id'          => 'about-stat-counter', 
            'description' => __( 'Add "Rara: Stat Counter Widget" for about stat counter section.', 'the-conference-pro' ),
        ),
        'about-testimonial' => array(
            'name'        => __( 'About Template Testimonial Section', 'the-conference-pro' ),
            'id'          => 'about-testimonial', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Testimonial" widget for testimonials.', 'the-conference-pro' ),
        ),
       'about-sponsor' => array(
            'name'        => __( 'About Template Sponsor Section', 'the-conference-pro' ),
            'id'          =>'about-sponsor', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Client Logo" Widget for Sponsors.', 'the-conference-pro' ),
        ),
       'speaker-template' => array(
            'name'        => __( 'Speaker Template Speaker Section', 'the-conference-pro' ),
            'id'          => 'speaker-template', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Team Member" Widget for Speakers.', 'the-conference-pro' ),
        ),
        'speaker-sponsor' => array(
            'name'        => __( 'Speaker Template Sponsor Section', 'the-conference-pro' ),
            'id'          => 'speaker-sponsor', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Client Logo" Widget for Sponsors.', 'the-conference-pro' ),
        ),
       'schedule-sponsor' => array(
            'name'        => __( 'Schedule Template Sponsor Section', 'the-conference-pro' ),
            'id'          => 'schedule-sponsor', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Client Logo" Widget for Sponsors.', 'the-conference-pro' ),
        ),
        'ticket-pricing' => array(
            'name'        => __( 'Ticket Template Pricing Section', 'the-conference-pro' ),
            'id'          => 'ticket-pricing', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Pricing Table Widget" for Pricing Tickets.', 'the-conference-pro' ),
        ),
        'ticket-faq' => array(
            'name'        => __( 'Ticket Template FAQ Section', 'the-conference-pro' ),
            'id'          => 'ticket-faq', 
            'description' => __( 'Add "Text" Widget for faq in Ticket Page Template.', 'the-conference-pro' ),
        ),
        'sponsor-template' => array(
            'name'        => __( 'Sponsor Template Sponsor Section', 'the-conference-pro' ),
            'id'          => 'sponsor-template', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Client Logo" Widget for Sponsors, Add "Rara: Call To Action" widget for Call to Action section.', 'the-conference-pro' ),
        ),
        'testimonial-template' => array(
            'name'        => __( 'Testimonial Template', 'the-conference-pro' ),
            'id'          => 'testimonial-template', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Testimonial" widget for testimonials.', 'the-conference-pro' ),
        ),
        'venue-details' => array(
            'name'        => __( 'Venue Template Details', 'the-conference-pro' ),
            'id'          => 'venue-details', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Contact Widget" Widget for contact details and social links. Add "Custom HTML" widget for Google Map.', 'the-conference-pro' ),
        ),
        'venue-sponsor' => array(
            'name'        => __( 'Venue Template Sponsor Section', 'the-conference-pro' ),
            'id'          => 'venue-sponsor', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: Client Logo" Widget for Sponsors, Add "Rara: Call To Action" widget for Call to Action section.', 'the-conference-pro' ),
        ),
        'venue-experience' => array(
            'name'        => __( 'Venue Template Experience Section', 'the-conference-pro' ),
            'id'          => 'venue-experience', 
            'description' => __( 'Add "Text" widget for title and description, Add "Image" widget for experiences.', 'the-conference-pro' ),
        ),
        'faq-template' => array(
            'name'        => __( 'FAQ Template', 'the-conference-pro' ),
            'id'          => 'faq-template', 
            'description' => __( 'Add "Text" widget for title and description, Add "Rara: FAQ" widget in FAQ Page Template.', 'the-conference-pro' ),
        ),
        'gallery-template' => array(
            'name'        => __( 'Gallery Template', 'the-conference-pro' ),
            'id'          => 'gallery-template', 
            'description' => __( 'Add "Text" widget for title and description, Add "Gallery" widget in Gallery Page Template.', 'the-conference-pro' ),
        ),
        'contact-template-details' => array(
            'name'        => __( 'Contact Template Details', 'the-conference-pro' ),
            'id'          => 'contact-template-details', 
            'description' => __( 'Add "Text" widget ( use shortcode ) to display contact form, Add "Rara: Contact Widget" Widget for contact details and social links.', 'the-conference-pro' ),
        ),
        'contact-template-gmap' => array(
            'name'        => __( 'Contact Template Map Settings', 'the-conference-pro' ),
            'id'          => 'contact-template-gmap', 
            'description' => __( 'Add "Custom HTML" widget for Google Map section.', 'the-conference-pro' ),
        ),
        'footer-one'=> array(
            'name'        => __( 'Footer One', 'the-conference-pro' ),
            'id'          => 'footer-one', 
            'description' => __( 'Add footer one widgets here.', 'the-conference-pro' ),
        ),
        'footer-two'=> array(
            'name'        => __( 'Footer Two', 'the-conference-pro' ),
            'id'          => 'footer-two', 
            'description' => __( 'Add footer two widgets here.', 'the-conference-pro' ),
        ),
        'footer-three'=> array(
            'name'        => __( 'Footer Three', 'the-conference-pro' ),
            'id'          => 'footer-three', 
            'description' => __( 'Add footer three widgets here.', 'the-conference-pro' ),
        ),
        'footer-four'=> array(
            'name'        => __( 'Footer Four', 'the-conference-pro' ),
            'id'          => 'footer-four', 
            'description' => __( 'Add footer four widgets here.', 'the-conference-pro' ),
        )
    );
    
    foreach( $sidebars as $sidebar ){
        register_sidebar( array(
    		'name'          => esc_html( $sidebar['name'] ),
    		'id'            => esc_attr( $sidebar['id'] ),
    		'description'   => esc_html( $sidebar['description'] ),
    		'before_widget' => '<section id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</section>',
    		'before_title'  => '<h2 class="widget-title" itemprop="name">',
    		'after_title'   => '</h2>',
    	) );
    }
    
    /** Dynamic sidebars */
    $dynamic_sidebars = the_conference_pro_get_dynamnic_sidebar();
    
    foreach( $dynamic_sidebars as $k => $v ){
        if( ! empty( $v ) ){
            register_sidebar( array(
                'name'          => esc_attr( $v ),
                'id'            => esc_attr( $k ),
                'description'   => '',
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget'  => '</section>',
                'before_title'  => '<h2 class="widget-title">',
                'after_title'   => '</h2>',
            ) );
        }
    }
}
add_action( 'widgets_init', 'the_conference_pro_widgets_init' );

/**
 * Addition of pricing widget.
 */
require get_template_directory() . '/inc/widgets/pricing-widget.php';