jQuery(document).ready(function ($) {

    var slider_auto, slider_loop, rtl, header_layout, winWidth;

    winWidth = $(window).width();

    if (the_conference_pro_data.auto == '1') {
        slider_auto = true;
    } else {
        slider_auto = false;
    }

    if (the_conference_pro_data.loop == '1') {
        slider_loop = true;
    } else {
        slider_loop = false;
    }

    if (the_conference_pro_data.rtl == '1') {
        rtl = true;
    } else {
        rtl = false;
    }

    // banner slider
    if ($('.home').length > 0) {
        $('#banner-slider').owlCarousel({
            loop: slider_loop,
            margin: 0,
            nav: true,
            items: 1,
            dots: false,
            autoplay: slider_auto,
            navText: '',
            rtl: rtl,
            lazyLoad: true,
            animateOut: the_conference_pro_data.animation,
        });
    }

    //Header Search form show/hide
    $('.site-header .nav-holder .form-holder').prepend('<div class="btn-close-form"><span></span></div>');

    $('.site-header .form-section').on('click', function (event) {
        event.stopPropagation();
    });
    $("#btn-search").on('click', function () {
        $(".site-header .form-holder").show("fast");
    });

    $('.btn-close-form').on('click', function () {
        $('.site-header .nav-holder .form-holder').hide("fast");
    });

    $('.language-dropdown li.menu-item-has-children > a').on('click', function (e) {
        e.preventDefault();
        $(this).siblings('ul').slideToggle();
    });

    /** Lightbox */
    if (the_conference_pro_data.lightbox == '1') {
        $('.entry-content').find('.gallery-columns-1').find('.gallery-icon > a').attr('data-fancybox', 'group1');
        $('.entry-content').find('.gallery-columns-2').find('.gallery-icon > a').attr('data-fancybox', 'group2');
        $('.entry-content').find('.gallery-columns-3').find('.gallery-icon > a').attr('data-fancybox', 'group3');
        $('.entry-content').find('.gallery-columns-4').find('.gallery-icon > a').attr('data-fancybox', 'group4');
        $('.entry-content').find('.gallery-columns-5').find('.gallery-icon > a').attr('data-fancybox', 'group5');
        $('.entry-content').find('.gallery-columns-6').find('.gallery-icon > a').attr('data-fancybox', 'group6');
        $('.entry-content').find('.gallery-columns-7').find('.gallery-icon > a').attr('data-fancybox', 'group7');
        $('.entry-content').find('.gallery-columns-8').find('.gallery-icon > a').attr('data-fancybox', 'group8');
        $('.entry-content').find('.gallery-columns-9').find('.gallery-icon > a').attr('data-fancybox', 'group9');

        $("a[href$='.jpg'],a[href$='.jpeg'],a[href$='.png'],a[href$='.gif'],[data-fancybox]").fancybox({
            buttons: [
                "zoom",
                //"share",
                "slideShow",
                "fullScreen",
                //"download",
                // "thumbs",
                "close"
            ]
        });
    }

    /**
    * First Letter of word to Drop Cap
    * https://stackoverflow.com/questions/5458605/first-word-selector 
    * https://paulund.co.uk/capitalize-first-letter-string-javascript
    */
    $.fn.wrapStart = function (numWords) {
        var node = this.contents().filter(function () {
            return this.nodeType == 3;
        }).first(),
            text = node.text(),
            first = text.split(" ", numWords).join(" ");
        firstLetter = first.charAt(0);
        finale = '<span class="dropcap">' + firstLetter + '</span>' + first.slice(1);

        if (!node.length)
            return;

        node[0].nodeValue = text.slice(first.length);
        node.before(finale);
    };
    if (the_conference_pro_data.singular == 1 && the_conference_pro_data.drop_cap == 1) {
        $('.entry-content p').wrapStart(1);
    }

    //calculate header height
    var headerHeight = $('header.site-header').outerHeight();
    $('header.page-header, body.home:not(.hasbanner) .site').css('padding-top', headerHeight);

    $('.header-lay1 + .site-banner .banner-caption, .header-lay2 + .site-banner .banner-caption, .header-lay3 + .site-banner .banner-caption').css('padding-top', headerHeight);

    if (the_conference_pro_data.sticky_header) {
        // Sticky Header
        var win_width = $(window).width();

        var mn = $(".site-header");
        mns = "sticky-menu";
        mn.addClass(mns);
        $(window).on('scroll', function () {
            if ($(this).scrollTop() > 10) {
                mn.addClass('menu-stick');
            } else {
                mn.removeClass('menu-stick');
            }
        });

        $('.single-post .site-main .sticky-social .article-share').css('top', headerHeight);
    }

    //Sticky widget
    if (the_conference_pro_data.sticky_widget == '1' && winWidth > 1024) {
        $("#secondary").stick_in_parent({
            offset_top: 60,
        });
    }

    if (the_conference_pro_data.onepage) {
        if (the_conference_pro_data.sticky_header == '1') {
            scrollOffset = headerHeight;
        } else {
            scrollOffset = 0;
        }
        /** One page Scroll */
        $('.main-navigation').onePageNav({
            currentClass: 'current-menu-item',
            changeHash: false,
            scrollSpeed: 1500,
            scrollThreshold: 0.5,
            scrollOffset: scrollOffset,
            filter: '',
            easing: 'swing',
        });
    }

    /** WOW Js */
    if (the_conference_pro_data.animate == '1') {
        slider_animate = true;
    } else {
        slider_animate = false;
    }

    if (slider_animate) {
        new WOW().init();
    }

    //page team popup js
    $('.speaker-content-block').on('click', function () {
        $(this).siblings('.speaker-popup-modal').addClass('show');
        $(this).siblings('.speaker-popup-modal').css('display', 'block');
    });

    $('.close_popup').on('click', function (e) {
        e.preventDefault();
        $(this).parent('.speaker-popup-modal').removeClass('show');
        $(this).parent().css('display', 'none');
    });

    //toggle js
    $('.toggle-block .toggle-desc').hide();
    $('.toggle-block.open .toggle-desc').show();
    $('.toggle-block .toggle-title').on('click', function () {
        $(this).parent('.toggle-block').siblings('.toggle-block').removeClass('open');
        $(this).parent('.toggle-block').addClass('open');
        $(this).parent('.toggle-block').siblings('.toggle-block').children('.toggle-desc').slideUp();
        $(this).parent('.toggle-block').children('.toggle-desc').slideDown();
    });

    //tab js
    $('.tab-content').hide();
    $('.tab-content.active').show();
    $('.tab-btn').on('click', function () {
        var divClas = $(this).attr('class');
        var arr = divClas.split(' ');
        var tabsClas = arr[0];
        $('.tab-btn').removeClass('active');
        $(this).addClass('active');
        $('.tab-content').hide();
        $('.tab-content').removeClass('active');
        $('.' + tabsClas + '-content').show().addClass('active');
    });

    //child tab js
    $('.childTab-content').hide();
    $('.childTab-content.active').show();
    $('.childTab-btn').on('click', function () {
        var divClas = $(this).attr('class');
        var arr = divClas.split(' ');
        var tabsClas = arr[0];
        $(this).siblings('.childTab-btn').removeClass('active');
        $(this).addClass('active');
        $(this).parent('.tab-wrap').siblings('.tab-description').children('.childTab-content').hide();
        $(this).parent('.tab-wrap').siblings('.tab-description').children('.childTab-content').removeClass('active');
        $(this).parent('.tab-wrap').siblings('.tab-description').children('.' + tabsClas + '-content').show().addClass('active');
    });

    $('.scroll-down').on('click', function () {
        $('html, body').animate({
            scrollTop: $(".scroll-down").parent('.item').parents('.site-banner').next().offset().top
        }, 800);
    });

    //scroll to top btn show/hide
    $(window).on('scroll', function () {
        if ($(window).scrollTop() > 200) {
            $('.scroll-to-top').addClass('show');
        } else {
            $('.scroll-to-top').removeClass('show');
        }
    });

    //scroll to top on click
    $('.scroll-to-top').on('click', function () {
        $('html, body').animate({
            scrollTop: 0
        }, 800);
    });

    //append responsive button
    $('.site-header .container').append('<button class="toggle-btn"><span class="bar"></span><span class="bar"></span><span class="bar"></span></button>');
    $('.site-header button.toggle-btn').on('click', function () {
        $('body').addClass('nav-toggled');
    });

    $('.main-navigation .toggle-button').on('click', function () {
        $('body').removeClass('nav-toggled');
    });

    $('.main-navigation li.menu-item-has-children').prepend('<span class="submenu-toggle"><i class="fa fa-angle-down"></i></span>');
    $('.menu-item-has-children .submenu-toggle').on('click', function () {
        $(this).toggleClass('active');
        $(this).siblings('ul').slideToggle();
    });


    $('.widget_rrtc_description_widget .description').mCustomScrollbar();

    //wrap widget title content with span
    $('#secondary .widget-title, .site-footer .widget-title').wrapInner('<span class="title-wrap"></span>');

    $("#site-navigation ul li a").focus(function () {
        $(this).parents("li").addClass("hover");
    }).blur(function () {
        $(this).parents("li").removeClass("hover");
    });

    $(".widget_rrtc_description_widget a, .gallery-section .widget_media_gallery .gallery-item a").focus(function () {
        $(this).parents(".widget_rrtc_description_widget").addClass("hover");
        $(this).parents(".gallery-item").addClass("hover");
    }).blur(function () {
        $(this).parents(".widget_rrtc_description_widget").removeClass("hover");
        $(this).parents(".gallery-item").removeClass("hover");
    });

    if ($('.home').length > 0) {
        //banner countdown
        if (the_conference_pro_data.ed_banner_timer == '1') {
            var bannerTime = moment.tz(the_conference_pro_data.banner_event_timer, the_conference_pro_data.time_zone);
            $('#bannerClock .days').countdown(bannerTime.toDate(), function (event) {
                $(this).html(event.strftime('%D'));
            });
            $('#bannerClock .hours').countdown(bannerTime.toDate(), function (event) {
                $(this).html(event.strftime('%H'));
            });
            $('#bannerClock .minutes').countdown(bannerTime.toDate(), function (event) {
                $(this).html(event.strftime('%M'));
            });
            $('#bannerClock .seconds').countdown(bannerTime.toDate(), function (event) {
                $(this).html(event.strftime('%S'));
            });
            $('#bannerClock').countdown(bannerTime.toDate()).on('finish.countdown', function (event) {
                if ($('.logged-in').length > 0) {
                    $(this).html('<p>' + the_conference_pro_data.event_expired + '</p>');
                } else {
                    $(this).remove();
                }
            });
        }

        // ctaTimer countdown
        if (the_conference_pro_data.ed_cta_timer == '1') {
            var ctaTime = moment.tz(the_conference_pro_data.cta_event_timer, the_conference_pro_data.time_zone);
            $('#ctaTimer .days').countdown(ctaTime.toDate(), function (event) {
                $(this).html(event.strftime('%D'));
            });
            $('#ctaTimer .hours').countdown(ctaTime.toDate(), function (event) {
                $(this).html(event.strftime('%H'));
            });
            $('#ctaTimer .minutes').countdown(ctaTime.toDate(), function (event) {
                $(this).html(event.strftime('%M'));
            });
            $('#ctaTimer .seconds').countdown(ctaTime.toDate(), function (event) {
                $(this).html(event.strftime('%S'));
            });
            $('#ctaTimer').countdown(ctaTime.toDate()).on('finish.countdown', function (event) {
                if ($('.logged-in').length > 0) {
                    $(this).html('<p>' + the_conference_pro_data.event_expired + '</p>');
                } else {
                    $(this).remove();
                }
            });
        }
    }
    // about template countdown
    if (the_conference_pro_data.ed_abotu_cta_timer == '1' && $('.page-template-about').length > 0) {
        var aboutCtaTime = moment.tz(the_conference_pro_data.about_event_timer, the_conference_pro_data.time_zone);
        $('#about_ctaTimer .days').countdown(aboutCtaTime.toDate(), function (event) {
            $(this).html(event.strftime('%D'));
        });
        $('#about_ctaTimer .hours').countdown(aboutCtaTime.toDate(), function (event) {
            $(this).html(event.strftime('%H'));
        });
        $('#about_ctaTimer .minutes').countdown(aboutCtaTime.toDate(), function (event) {
            $(this).html(event.strftime('%M'));
        });
        $('#about_ctaTimer .seconds').countdown(aboutCtaTime.toDate(), function (event) {
            $(this).html(event.strftime('%S'));
        });
        $('#about_ctaTimer').countdown(aboutCtaTime.toDate()).on('finish.countdown', function (event) {
            if ($('.logged-in').length > 0) {
                $(this).html('<p>' + the_conference_pro_data.event_expired + '</p>');
            } else {
                $(this).remove();
            }
        });
    }
});
