<?php
/**
 * About Template Timer Cta Section
 * 
 * @package The_Conference_Pro
 */

$default_bg      = get_template_directory_uri() . '/images/counter-bg.jpg';
$timer_cta_bg    = get_theme_mod( 'about_timer_cta_bg_image', $default_bg );
$title           = get_theme_mod( 'about_timer_cta_title', __( 'Hurry Up For Early Bird Tickets!', 'the-conference-pro' ) );
$description     = get_theme_mod( 'about_timer_cta_description', __( 'See what other people are saying about us', 'the-conference-pro' ) );
$show_event_time = get_theme_mod( 'ed_about_event_timer', true );
$event_datetime  = get_theme_mod( 'about_timer_cta_event_time', '2022-08-20' );
$event_time      = get_theme_mod( 'about_cta_event_time', '00:00' );
$readmore_label  = get_theme_mod( 'about_timer_cta_readmore_label', __( 'BUY TICKET NOW', 'the-conference-pro' ) );
$readmore_url    = get_theme_mod( 'about_timer_cta_readmore_url', '#' );
$style           = '';

if( $timer_cta_bg ){
	$style = ' style="background-image: url('. esc_url( $timer_cta_bg ) .'); background-repeat: no-repeat;"';
}
?>

<section id="about_timer_cta_section" class="ctatimer-section wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.1s"<?php echo $style ?>>
	<div class="container">
		<?php 
			if( $title ){
				echo '<h2 class="section-title">'. esc_html( $title ).'</h2>';
			}

			if( $description ){
				echo '<div class="section-desc">'. wpautop( wp_kses_post( $description ) ) .'</div>';
			}

			if( $show_event_time && $event_datetime && $event_time ){?>
				<div id="about_ctaTimer" class="ctaTimer-countdown">
					<div class="countdown-wrap">
						<span class="days">00</span>
						<div class="smalltext"><?php esc_html_e( 'Days', 'the-conference-pro' ); ?></div>
					</div>
					<div class="countdown-wrap">
						<span class="hours">00</span>
						<div class="smalltext"><?php esc_html_e( 'Hours', 'the-conference-pro' ); ?></div>
					</div>
					<div class="countdown-wrap">
						<span class="minutes">00</span>
						<div class="smalltext"><?php esc_html_e( 'Minutes', 'the-conference-pro' ); ?></div>
					</div>
					<div class="countdown-wrap">
						<span class="seconds">00</span>
						<div class="smalltext"><?php esc_html_e( 'Seconds', 'the-conference-pro' ); ?></div>
					</div>
				</div>
				<?php 
			}

			if( $readmore_label && $readmore_url ){ ?>
				<div class="btn-wrap">
					<a href="<?php echo esc_url( $readmore_url ); ?>" class="btn-filled"><?php echo esc_html( $readmore_label ); ?></a>
				</div>
			<?php } 
		?>
	</div>
</section> <!-- .ctatimer-section -->