<?php
/**
 * Faq Section
 * 
 * @package The_Conference_Pro
 */

$template_url = the_conference_pro_get_template_page_url( 'templates/faq.php', 'page' );
$button_label = get_theme_mod( 'faq_viewall_label',  __( 'VIEW ALL', 'the-conference-pro' ) );

if( is_active_sidebar( 'faq' ) ){ ?>
	<section id="faq_section" class="faq-section wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.1s">
		<div class="container">
			<div class="faq-content-wrap">
		    	<?php dynamic_sidebar( 'faq' ); ?>
		    </div>

		     <?php if( ! empty( $button_label ) && ! empty( $template_url ) ){ ?>
			    <div class="btn-wrap">
					<a href="<?php echo esc_url( $template_url ); ?>" class="btn-filled"><?php echo esc_html( $button_label ); ?></a>
				</div>
			<?php } ?>
			
	    </div>
	</section> <!-- .service-section -->
	<?php
}