<?php
/**
 * Schedule Section
 * 
 * @package The_Conference_Pro
 */

$section_title       = get_theme_mod( 'schedule_section_title', __( 'Schedule', 'the-conference-pro' ) ); 
$section_description = get_theme_mod( 'schedule_section_subtitle', __( 'Highly configurable block with optional auditoriums and threads', 'the-conference-pro' ) );
$template_url 		 = the_conference_pro_get_template_page_url( 'templates/schedule.php', 'page' );
$section_readmore    = get_theme_mod( 'schedule_section_readmore', __( 'VIEW DETAILS', 'the-conference-pro' ) );
?>
	<section id="schedule_section" class="schedule-section wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.1s">
		<div class="schedule-content-holder">
			<div class="container">
				<?php 
					if( $section_title ) echo '<h2 class="section-title">'. esc_html( $section_title ) .'</h2>'; 
					if( $section_description ) echo '<div class="section-desc">'. wpautop( wp_kses_post( $section_description ) ).'</div>';
					the_conference_pro_get_schedule( $template_url, $section_readmore );
				?>
			</div>
		</div>
	</section> <!-- .schedule-section -->
