<?php
/**
 * Testimonial Section
 * 
 * @package The_Conference_Pro
 */

$template_url = the_conference_pro_get_template_page_url( 'templates/testimonial.php', 'page' );
$button_label = get_theme_mod( 'testimonial_viewall_label',  __( 'SEE ALL TESTIMONIALS', 'the-conference-pro' ) );

if( is_active_sidebar( 'testimonial' ) ){ ?>
	<section id="testimonial_section" class="testimonial-section wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.1s">
		<div class="container">
			<div class="testimonial-wdgt-wrap">
		    	<?php dynamic_sidebar( 'testimonial' ); ?>
		    </div>

		    <?php if( ! empty( $button_label ) && ! empty( $template_url ) ){ ?>
			    <div class="btn-wrap">
					<a href="<?php echo esc_url( $template_url ); ?>" class="btn-filled"><?php echo esc_html( $button_label ); ?></a>
				</div>
			<?php } ?>
		</div>
	</section> <!-- .testimonial-section -->
<?php
}