<?php
/**
 * Ticket Section
 * 
 * @package The_Conference_Pro
 */

$default_bg = get_template_directory_uri() . '/images/counter-bg.jpg';
$ticket_bg  = get_theme_mod( 'ticket_bg_image', $default_bg );
$template_url = the_conference_pro_get_template_page_url( 'templates/ticket.php', 'page' );
$button_label = get_theme_mod( 'ticket_viewall_label', __( 'VIEW TICKETS', 'the-conference-pro' ) );
$style      = '';

if( $ticket_bg ){
	$style = ' style="background-image: url('. esc_url( $ticket_bg ) .'); background-repeat: no-repeat;"';
}

if( is_active_sidebar( 'ticket' ) ){ ?>
	<section id="ticket_section" class="pricingtable-section"<?php echo $style ?>>
		<div class="container">
			
			<div class="pricingtable-wrap">
	    		<?php dynamic_sidebar( 'ticket' ); ?>
			</div>

	    	<?php if( ! empty( $button_label ) && ! empty( $template_url ) ){ ?>
			    <div class="btn-wrap">
					<a href="<?php echo esc_url( $template_url ); ?>" class="btn-filled"><?php echo esc_html( $button_label ); ?></a>
				</div>
			<?php } ?>
	    </div>
	</section> <!-- .service-section -->
	<?php
}