<?php
/**
 * Template Name: Schedule Page
 * 
 * @package The_Conference_Pro
 */

get_header();
	if( is_rara_theme_companion_activated() ){
		$schedule_title  = get_theme_mod( 'st_section_title', __( 'Event Programme', 'the-conference-pro' ) );
		$schedule_desc   = get_theme_mod( 'st_section_description', __( 'Don\'t Miss a Thing', 'the-conference-pro' ) );
		$ticket_url      = get_theme_mod( 'st_ticket_url', '#' );
		$ticket_readmore = get_theme_mod( 'st_ticket_readmore', __( 'BUY TICKET NOW', 'the-conference-pro' ) );
	?>
		<div id="schedule_heading_section" class="container">
			<div id="primary" class="content-area">
				<main id="main" class="site-main">
					<?php 
						if( $schedule_title ) echo '<h1 class="section-title">'. esc_html( $schedule_title ) .'</h1>';
						if( $schedule_desc ) echo '<div class="section-desc">'. wpautop( wp_kses_post( $schedule_desc ) ) .'</div>';
						the_conference_pro_get_schedule( $ticket_url, $ticket_readmore );
					?>
				</main>
			</div> <!-- #primary -->
		</div> <!-- .container -->
	<?php } 

	if( is_active_sidebar( 'schedule-sponsor' ) ){ ?>
		<section id="schedule_sponsor_section" class="event-sponsor-section wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.1s">
			<div class="container">
				<?php dynamic_sidebar( 'schedule-sponsor' );  ?>
			</div>
		</section> <!-- .event-sponsor-section -->
	<?php
	}
	
get_footer();