<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package The_Conference_Pro
 */

// Includes the files needed for the theme updater
if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
}

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => 'https://rarathemes.com', // Site where EDD is hosted
		'item_name'      => 'The Conference Pro', // Name of theme
		'theme_slug'     => 'the-conference-pro', // Theme slug
		'version'        => '2.2.1', // The current version of this theme
		'author'         => 'Rara Theme', // The author of this theme
		'download_id'    => '312010', // Optional, used for generating a license renewal link
		'renew_url'      => '', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
		'item_id'        => '',
	),

	// Strings
	$strings = array(
		'theme-license'             => __( 'Getting Started', 'the-conference-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'the-conference-pro' ),
		'license-key'               => __( 'License Key', 'the-conference-pro' ),
		'license-action'            => __( 'License Action', 'the-conference-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'the-conference-pro' ),
		'activate-license'          => __( 'Activate License', 'the-conference-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'the-conference-pro' ),
		'renew'                     => __( 'Renew?', 'the-conference-pro' ),
		'unlimited'                 => __( 'unlimited', 'the-conference-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'the-conference-pro' ),
		'expires%s'                 => __( 'Expires %s.', 'the-conference-pro' ),
		'expires-never'             => __( 'Lifetime License.', 'the-conference-pro' ),
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'the-conference-pro' ),
		'license-key-expired-%s'    => __( 'License key expired %s.', 'the-conference-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'the-conference-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'the-conference-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'the-conference-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'the-conference-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'the-conference-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'the-conference-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'the-conference-pro' ),
		'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4$s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'the-conference-pro' ),
	)

);
